<?php

/**
 * Extend WooCommerce Functions
 *
 * @author     Andon
 * @package    Alpha FrameWork
 * @subpackage Theme
 * @since      4.1
 */

add_filter( 'woocommerce_shortcode_products_query', 'alpha_woo_products_in_custom_tax', 20, 2 );

if ( ! function_exists( 'alpha_woo_products_in_custom_tax' ) ) {
	/**
	 * Products in specified brands
	 */
	function alpha_woo_products_in_custom_tax( $args, $attributes ) {
		if ( ! empty( $attributes['class'] ) ) {
			$classes = explode( ',', $attributes['class'] );

			if ( ! in_array( 'custom_brands', $classes ) ) {
				return $args;
			}

			$args['tax_query'][] = array(
				'taxonomy' => 'product_brand',
				'terms'    => array_map( 'sanitize_title', $classes ),
				'field'    => 'slug',
				'operator' => 'IN',
			);

		}

		return $args;
	}
}

//Shop Builder
if ( function_exists( 'alpha_remove_custom_filter' ) ) {
	alpha_remove_custom_filter( 'loop_shop_per_page', 'alpha_loop_shop_per_page' );
}
add_filter( 'wp', 'alpha_loop_shop_per_page' );

if ( ! function_exists( 'alpha_loop_shop_per_page' ) ) {
	function alpha_loop_shop_per_page( $count_select = '' ) {
		if ( ! empty( $_GET['count'] ) ) {
			return (int) $_GET['count'];
		}
		if ( ! is_array( $count_select ) ) {

			$count_select = '';

			if ( ! $count_select ) {
				/**
				 * Filters the count of showing products.
				 *
				 * @since 1.0
				 */
				$count_select = apply_filters( 'alpha_products_count_select', alpha_get_option( 'products_count_select' ) );
			}

			if ( $count_select ) {
				$count_select = explode( ',', str_replace( ' ', '', $count_select ) );
			} else {
				$count_select = array( '9', '_12', '24', '36' );
			}
		}

		$default = $count_select[0];

		foreach ( $count_select as $num ) {
			if ( is_string( $num ) && '_' == substr( $num, 0, 1 ) ) {
				$default = (int) str_replace( '_', '', $num );
				break;
			}
		}

		return $default;
	}
}
