<?php
/**
 * History of theme
 *
 * Here, you can add or remove whats new content and change log.
 *
 * @author     Andon
 * @package    Alpha FrameWork
 * @subpackage Theme
 * @since      4.0
 */

if ( empty( $history_type ) ) {
	return;
}

// What's New Section
if ( 'whatsnew' == $history_type ) {
	?>
	<div class="alpha-whatsnew-item">
		<h3 class="alpha-item-title"><?php printf( esc_html__( 'Step into WordPress %1$s5.7.1%2$s', 'alpha' ), '<span class="text-primary">', '</span>' ); ?></h3>
		<p class="alpha-item-desc">
		<?php
		echo esc_html__(
			'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore ctetur adipis
magna aliqua. Venenatis tellus in metus vulputate eu scelerisque felis. Vel pretium lectus quam id leo in vitae us in metus vulpu
turpis massa. Nunc id cursus metus aliquam. Libero id faucibus nisl tincidunt eget. Aliquam id diam maecenas ero id fauci
ultricies mi eget mauris.',
			'alpha'
		);
		?>
		</p>
	</div>
	<div class="alpha-whatsnew-item">
		<h4 class="alpha-item-title"><?php echo esc_html__( 'Maintenance and Security Releases', 'alpha' ); ?></h4>
		<p class="alpha-item-desc">
		<?php
		printf(
			esc_html__(
				'Version 5.7.1 addressed some security issues and fixed 26 bugs. For more information, see %1$sthe release notes%2$s.',
				'alpha'
			),
			'<a href="#">',
			'</a>'
		);
		?>
		</p>
	</div>
	<?php
} elseif ( 'changelog' == $history_type ) {
	?>
	<div class="alpha-changelog">
	<h4 class="alpha-release-version"><?php echo esc_html__( 'Version 4.1 (15th May 2022)', 'alpha' ); ?></h4>
		<h5 class="alpha-log-title"><i class="fas fa-star"></i><?php echo esc_html__( 'Added', 'alpha' ); ?></h5>
		<ul>
			<li><?php esc_html_e( 'Compatibility with WordPress 5.9.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Optimized function - critical css for increasing google page speed.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Optimized function - defer loading and merge stylesheets and javascript files in a file.', 'alpha' ); ?></li>
			<li><?php printf( '%1$s – <a href="https://d-themes.com/wordpress/udesign/dentist/" target="_black">%2$s</a>, <a href="https://d-themes.com/wordpress/udesign/furniture/" target="_black">%3$s</a>, <a href="https://d-themes.com/wordpress/udesign/app/" target="_black">%4$s</a>, <a href="https://d-themes.com/wordpress/udesign/gym/" target="_black">%5$s</a>, <a href="https://d-themes.com/wordpress/udesign/shoes/" target="_black">%6$s</a>, <a href="https://d-themes.com/wordpress/udesign/tea/" target="_black">%7$s</a>, <a href="https://d-themes.com/wordpress/udesign/jewelry/" target="_black">%8$s</a>, <a href="https://d-themes.com/wordpress/udesign/fashion-2/" target="_black">%9$s</a>, <a href="https://d-themes.com/wordpress/udesign/landing-product/" target="_black">%10$s</a>, <a href="https://d-themes.com/wordpress/udesign/beauty/" target="_black">%11$s</a>, <a href="https://d-themes.com/wordpress/udesign/babycare/" target="_black">%12$s</a>, <a href="https://d-themes.com/wordpress/udesign/wine/" target="_black">%13$s</a>, <a href="https://d-themes.com/wordpress/udesign/business-consulting/" target="_black">%14$s</a>, <a href="https://d-themes.com/wordpress/udesign/burger/" target="_black">%15$s</a>, <a href="https://d-themes.com/wordpress/udesign/law-firm/" target="_black">%16$s</a>', esc_html__( '15 Niche Demos', 'alpha' ), esc_html__( 'Dental', 'alpha' ), esc_html__( 'Furniture', 'alpha' ), esc_html__( 'App Landing', 'alpha' ), esc_html__( 'Gym', 'alpha' ), esc_html__( 'Shoes', 'alpha' ), esc_html__( 'Tea', 'alpha' ), esc_html__( 'Jewelry', 'alpha' ), esc_html__( 'Fashion 2', 'alpha' ), esc_html__( 'Product Landing', 'alpha' ), esc_html__( 'Beauty', 'alpha' ), esc_html__( 'Baby', 'alpha' ), esc_html__( 'Wine', 'alpha' ), esc_html__( 'Business Consulting', 'alpha' ), esc_html__( 'Burger', 'alpha' ), esc_html__( 'Law Firm', 'alpha' ) ); ?></li>
			<li><?php esc_html_e( '150+ block templates.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Type Builder for custom post type.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Gutenberg adnvaced style in widget for type builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Featured image widget for type builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Meta widget for type builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Woo buttons widget for type builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Woo description widget for type builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Woo price widget for type builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Woo rating widget for type builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Woo stock widget for type builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Content widget for type builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Post grid wiget for type builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Type bulider archives widget for shop and archive builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Wireframe in header and footer builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Cart Builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Cart Builder - woo coupons widget.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Cart Builder - woo shipping widget.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Cart Builder - woo cart table widget.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Cart Builder - woo cart totals widget.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Checkout Builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Checkout Builder - woo billing widget.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Checkout Builder - woo payment widget.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Checkout Builder - woo review widget.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Checkout Builder - woo checkout shipping widget.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Gutenberg Widget - Heading widget.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Gutenberg Widget - Button widget.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Gutenberg Widget - Container widget.', 'alpha' ); ?></li>
			<li><?php esc_html_e( '"merge css and js files" function in tools page.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Side header options in header builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Popup dynamic link tag.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Warning descriptions to the child menu item of the megamenu that say how it works in menu editing page.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'UDesign Studio allowing to import post types.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with WooCommerce 6.4.1.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Half container option in Elementor Column element.', 'alpha' ); ?></li>
		</ul>
		<h5 class="alpha-log-title"><i class="fas fa-undo-alt"></i><?php echo esc_html__( 'Updated', 'alpha' ); ?></h5>
		<ul>
			<li><?php esc_html_e( 'Studio search function and add various categories of block.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Studio to be appeared on the same screen with the page layout.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Setup wizard and optimize wizard for user-friendly and fixed sort of errors.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Sidebar legacy widget style and newly-gutenberg block style.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Archive Builder because of mini type builder and fixed sort of errors.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Single Builder because of mini type builder and fixed sort of errors.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Shop Builder because of mini type builder and fixed sort of errors.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Single Product Builder because of mini type builder and fixed sort of errors.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Header Builder for user-friendly and fixed sort of errors.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Layout builder because of full-site builders. Removed some unnecessary options.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Sticky header animation.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Redirects to elementor preview just after creating a new UDesign template.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Section Slider widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Column Slider widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Tab widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Accordion widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Section Banner widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Creative Grid widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( '360 degree widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Animated-text widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Banner widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Bar chart widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Block widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Brands widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Breadcrumb widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Button widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Contact widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Countdown widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Filter widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Flipbox widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Heading widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Highlight widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Hotspot widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Iconlist widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Image box widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Image compare widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Image gallery widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Line chart widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Logo widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Menu widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Pie doughnut widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Polar chart widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Price tables widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Progressbars widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Radar chart widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Search widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Share widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Table widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Testimonial widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Timeline widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Timeline horizontal widget for optimized and user-friendly.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'LearnPress sidebar widgets\' query.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Advanced Tab in elementor: duplex, ribbon, floating.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Layout builder using page filter.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Elementor Compatibility issue.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'License manager.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Documentation.', 'alpha' ); ?></li>
		</ul>
		<h5 class="alpha-log-title"><i class="fas fa-bug"></i><?php echo esc_html__( 'Fixed', 'alpha' ); ?></h5>
		<ul>
			<li><?php esc_html_e( 'White label addon\'s admin style.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'In customzie preview, tooltip does not appear after selective refresh works.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Product metabox is not saved when product is updated.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Block style compatiblity with Elementor style internal / external print method.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Duplex element in elementor preview and section and column.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Ribbon element in elementor preview and section and column .', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Mini cart quantity input in cart Popup.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Post like action hook.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Product compare list issue in quickview, archive page, label change issue when it is removed from list.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Comments pagination compatibility issue with custom post types.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Product 360 degree gallery admin style issue.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Add to cart sticky thumbnail issue when product featured image is empty.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Product brand missing issue in single product default templates.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Product buy now button style.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Product video thumbnail icon.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Sticky column does not work in elementor preview.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Icon box widget style issue causes of Elementor style internal / external print method.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Price table widget style issue causes of Elementor style internal / external print method.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Testimonial widget style issue causes of Elementor style internal / external print method.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Search widget style issue causes of Elementor style internal / external print method.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Banner widget style issue causes of Elementor style internal / external print method.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Banner hotspot style issue causes of Elementor style internal / external print method.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Breadcrumb issue when post type slug is changed in theme option.', 'alpha' ); ?></li>
		</ul>
		<h4 class="alpha-release-version" style="margin-top: 40px"><?php echo esc_html__( 'Version 4.0 (23th January 2022)', 'alpha' ); ?></h4>
		<h5 class="alpha-log-title"><i class="fas fa-star"></i><?php echo esc_html__( 'Added', 'alpha' ); ?></h5>
		<ul>
			<li><?php echo esc_html__( 'Compatibility with WordPress 5.8.', 'alpha' ); ?></li>
			<li><?php echo esc_html__( 'UDesign admin Dashboard, integrating all components of UDesign into one main area.', 'alpha' ); ?></li>
			<li><?php printf( '%1$s – <a href="https://d-themes.com/wordpress/udesign/main/" target="_black">%2$s</a>, <a href="https://d-themes.com/wordpress/udesign/corporate/" target="_black">%3$s</a>, <a href="https://d-themes.com/wordpress/udesign/farm-store/" target="_black">%4$s</a>, <a href="https://d-themes.com/wordpress/udesign/health-coach/" target="_black">%5$s</a>, <a href="https://d-themes.com/wordpress/udesign/photography/" target="_black">%6$s</a>, <a href="https://d-themes.com/wordpress/udesign/yoga/" target="_black">%7$s</a>, <a href="https://d-themes.com/wordpress/udesign/build/" target="_black">%8$s</a>, <a href="https://d-themes.com/wordpress/udesign/fashion/" target="_black">%9$s</a>, <a href="https://d-themes.com/wordpress/udesign/cannabis/" target="_black">%10$s</a>, <a href="https://d-themes.com/wordpress/udesign/medical/" target="_black">%11$s</a>, <a href="https://d-themes.com/wordpress/udesign/clean-home/" target="_black">%12$s</a>, <a href="https://d-themes.com/wordpress/udesign/education/" target="_black">%13$s</a>, <a href="https://d-themes.com/wordpress/udesign/real-estate/" target="_black">%14$s</a>, <a href="https://d-themes.com/wordpress/udesign/resume/" target="_black">%15$s</a>, <a href="https://d-themes.com/wordpress/udesign/restaurant/" target="_black">%16$s</a>', esc_html__( '15 Niche Demos', 'alpha' ), esc_html__( 'Main', 'alpha' ), esc_html__( 'Corporate', 'alpha' ), esc_html__( 'Farm Store', 'alpha' ), esc_html__( 'Health Coach', 'alpha' ), esc_html__( 'Photography', 'alpha' ), esc_html__( 'Yoga', 'alpha' ), esc_html__( 'Build', 'alpha' ), esc_html__( 'Fashion', 'alpha' ), esc_html__( 'Cannabis', 'alpha' ), esc_html__( 'Medical', 'alpha' ), esc_html__( 'Cleaning', 'alpha' ), esc_html__( 'Education', 'alpha' ), esc_html__( 'Real Estate', 'alpha' ), esc_html__( 'Resume', 'alpha' ), esc_html__( 'Restaurant', 'alpha' ) ); ?></li>
			<li><?php esc_html_e( 'UDesign studio including 150+ prebuilt blocks.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Speed Optimize Wizard essential to site speed up.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Demo uninstall functionality for site clean up.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with Elementor.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Add tooltip instead of control description in elementor preview.', 'alpha' ); ?></li>
			<li><?php esc_html_e( '60+ elementor widgets.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Sticky option to elementor column element.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Dynamic tags are included to elementor widgets.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Full site edit possibility – header, footer, popup, sidebar builders.', 'alpha' ); ?></li>
			<li><?php esc_html_e( '8 header builder widgets.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Layout builder system to customize layout of any single or archive page.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Single & Archive builder for custom post types using Elementor.', 'alpha' ); ?></li>
			<li><?php esc_html_e( '11 single builder widgets.', 'alpha' ); ?></li>
			<li><?php esc_html_e( '2 archive builder widgets.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Megamenu builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Lazy load image & menu.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Live search functionality.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with WooCommerce 6.0.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'WooCommerce single product builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( '18 single product builder widgets.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'WooCommerce shop builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( '7 shop builder widgets.', 'alpha' ); ?></li>
			<li><?php esc_html_e( '6+ different product types.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Ajax loading compatible with WooCommerce.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Product compare functionality.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Product brand attribute and elementor widget.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Product frequently bought together functionality.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Product 360 degree and featured video.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Custom swatches for WooCommerce variable products: colors, images, buttons.', 'alpha' ); ?></li>
			<li><?php esc_html_e( '3 effective quickview types.', 'alpha' ); ?></li>
			<li><?php esc_html_e( '3 unique shop layouts.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with Advanced Custom Fields.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with Post Types Unlmited.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with LearnPress.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with Kirki customizer.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with WPML.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with WPForms Lite.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with The Events Calendar.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with Modern Events Calendar.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with Yith WooCommerce Wishlist.', 'alpha' ); ?></li>
		</ul>
		<h5 class="alpha-log-title"><i class="fas fa-undo-alt"></i><?php echo esc_html__( 'Updated', 'alpha' ); ?></h5>
		<ul>
			<li><?php esc_html_e( 'Theme options panel.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Elementor editor interface.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Setup Wizard for quick theme installation.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Demo import engine working well even after multiple imports.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Enhanced code quality based on robust framework.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with Revolution Slider.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Compatibility with Essential Grid to work with single & archive builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Documentation posts for 4.0 features.', 'alpha' ); ?></li>
		</ul>
		<h5 class="alpha-log-title"><i class="fas fa-bug"></i><?php echo esc_html__( 'Removed', 'alpha' ); ?></h5>
		<ul>
			<li><?php esc_html_e( 'All demos built with WPBakery page builder.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'UDesign admin dashboard & settings panel.', 'alpha' ); ?></li>
			<li><?php esc_html_e( 'Dozens of theme options from version 3.x.', 'alpha' ); ?></li>
		</ul>
	</div>
	<?php
}
