<?php
/**
 * Theme Functions
 *
 * @author     Andon
 * @package    Alpha FrameWork
 * @subpackage Theme
 * @since      4.0
 */
defined( 'ABSPATH' ) || die;

if ( ! function_exists( 'alpha_get_overlay_class' ) ) {
	function alpha_get_overlay_class( $overlay ) {
		if ( 'light' == $overlay || 'dark' == $overlay || 'zoom' == $overlay ) {
			return 'overlay-' . $overlay;
		}
		if ( 'zoom_light' == $overlay ) {
			return 'overlay-zoom overlay-light';
		}
		if ( 'zoom_dark' == $overlay ) {
			return 'overlay-zoom overlay-dark';
		}
		return '';
	}
}

if ( ! function_exists( 'alpha_comment_form_args' ) ) {
	function alpha_comment_form_args( $args ) {
		$args['title_reply_before'] = '<h3 id="reply-title" class="comment-reply-title">';
		$args['title_reply_after']  = '</h3>';
		$args['fields']['author']   = '<div class="col-md-6"><input name="author" type="text" class="form-control" value="" placeholder="' . esc_attr__( 'Your Name', 'alpha' ) . '"> </div>';
		$args['fields']['email']    = '<div class="col-md-6"><input name="email" type="text" class="form-control" value="" placeholder="' . esc_attr__( 'Your Email', 'alpha' ) . '"> </div>';

		$args['comment_field']  = isset( $args['comment_field'] ) ? $args['comment_field'] : '';
		$args['comment_field']  = substr( $args['comment_field'], 0, strpos( $args['comment_field'], '<p class="comment-form-comment">' ) );
		$args['comment_field'] .= '<textarea name="comment" id="comment" class="form-control" rows="6" maxlength="65525" required="required" placeholder="' . esc_attr__( 'Write Your Commet Here&hellip;', 'alpha' ) . '"></textarea>';
		$args['submit_button']  = '<button type="submit" class="btn btn-primary btn-submit">' .
			( alpha_is_product() ? esc_html__( 'Submit Review', 'alpha' ) : esc_html__( 'Post Comment', 'alpha' ) . ' <i class=" ' . ALPHA_ICON_PREFIX . '-icon-long-arrow-right"></i>' ) . '</button>';

		return $args;
	}
}

if ( ! function_exists( 'alpha_post_comment' ) ) {
	function alpha_post_comment( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;
		?>
		<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">

				<?php if ( 'pingback' == $comment->comment_type || 'trackback' == $comment->comment_type ) { ?>
			<div id="comment-<?php comment_ID(); ?>" class="comment comment-container">
				<p><?php esc_html_e( 'Pingback:', 'alpha' ); ?> <span><span><?php comment_author_link( get_comment_ID() ); ?></span></span> <?php edit_comment_link( esc_html__( '(Edit)', 'alpha' ), '<span class="edit-link">', '</span>' ); ?></p>
			</div>
			<?php } else { ?>
			<div class="comment">
				<figure class="comment-avatar">
					<?php echo get_avatar( $comment, 50 ); ?>
				</figure>

				<div class="comment-text">
					<div class="comment-header">
						<div class="comment-meta">
							<?php /* translators: %s represents the date of the comment. */ ?>
							<h5 class="comment-date"><?php printf( esc_html__( '%1$s at %2$s', 'alpha' ), get_comment_date(), get_comment_time() ); ?></h5>
							<h4 class="comment-name"><?php echo get_comment_author_link( get_comment_ID() ); ?></h4>
						</div>
						<?php
						comment_reply_link(
							array_merge(
								$args,
								array(
									'add_below' => 'comment',
									'depth'     => $depth,
									'max_depth' => $args['max_depth'],
								)
							)
						);
						?>
					</div>

					<?php
					if ( '0' == $comment->comment_approved ) {
						echo '<em>' . esc_html__( 'Your comment is awaiting moderation.', 'alpha' ) . '</em>';
						echo '<br />';
					}
					comment_text();
					?>
				</div>
			</div>
					<?php
			}
	}
}

/**
 * Set loop prop for woocommerce
 *
 * @since 1.0
 */
function alpha_wc_set_loop_prop() {
	// Category Props //////////////////////////////////////////////////////////////////////////////
	wc_set_loop_prop( 'category_type', alpha_get_option( 'category_type' ) );
	wc_set_loop_prop( 'overlay', alpha_get_option( 'category_overlay' ) );

	// Product Props ///////////////////////////////////////////////////////////////////////////////
	wc_set_loop_prop( 'product_type', alpha_get_option( 'product_type' ) );

	if ( alpha_is_shop() || alpha_is_product() ) {
		wc_set_loop_prop( 'show_labels', array( 'hot', 'sale', 'new', 'stock' ) );
	}

	global $alpha_layout;
	$info   = alpha_get_option( 'show_info' );
	$info[] = 'countdown';
	wc_set_loop_prop( 'show_info', $info );
}

/**
 * Loadmore html
 *
 * @since 1.0
 */
function alpha_loadmore_html( $query, $loadmore_type, $loadmore_label, $loadmore_btn_style = '', $name_prefix = '' ) {
	if ( 'button' == $loadmore_type ) {
		$class = 'btn btn-load ';

		if ( $loadmore_btn_style ) {
			$class .= function_exists( 'alpha_widget_button_get_class' ) ? implode( ' ', alpha_widget_button_get_class( $loadmore_btn_style, $name_prefix ) ) : '';
		} else {
			$class .= 'btn-primary btn-outline btn-md';
		}

		$label = empty( $loadmore_label ) ? esc_html__( 'Load More', 'alpha' ) : esc_html( $loadmore_label );
		echo '<button class="' . esc_attr( $class ) . '">' . ( $loadmore_btn_style && function_exists( 'alpha_widget_button_get_label' ) ? alpha_widget_button_get_label( $loadmore_btn_style, null, $label, $name_prefix ) : $label ) . '</button>';
	} elseif ( 'page' == $loadmore_type || ! $loadmore_type ) {
		echo alpha_get_pagination( $query, 'pagination-load' );
	}
}

/**
 * Save theme options
 * @since 4.0
 */
function alpha_save_theme_options() {
	ob_start();

	require_once alpha_framework_path( ALPHA_FRAMEWORK_ADMIN . '/customizer/customizer-function.php' );
	require_once alpha_framework_path( ALPHA_FRAMEWORK_ADMIN . '/customizer/dynamic/dynamic_vars.php' );

	global $wp_filesystem;
	// Initialize the WordPress filesystem, no more using file_put_contents function
	if ( empty( $wp_filesystem ) ) {
		require_once( ABSPATH . '/wp-admin/includes/file.php' );
		WP_Filesystem();
	}

	try {
		$target      = wp_upload_dir()['basedir'] . '/' . ALPHA_NAME . '_styles/dynamic_css_vars.css';
		$target_path = dirname( $target );
		if ( ! file_exists( $target_path ) ) {
			wp_mkdir_p( $target_path );
		}

		// check file mode and make it writable.
		if ( is_writable( $target_path ) == false ) {
			@chmod( get_theme_file_path( $target ), 0755 );
		}
		if ( file_exists( $target ) ) {
			if ( is_writable( $target ) == false ) {
				@chmod( $target, 0755 );
			}
			@unlink( $target );
		}

		$wp_filesystem->put_contents( $target, ob_get_clean(), FS_CHMOD_FILE );
	} catch ( Exception $e ) {
		var_dump( $e );
		var_dump( 'error occured while saving dynamic css vars.' );
	}
}

if ( ! function_exists( 'alpha_print_title_bar' ) ) {
	function alpha_print_title_bar() {
		global $alpha_layout;

		if ( is_front_page() ) {
			// Do not show page title bar and breadcrumb in home page.
		} else {
			if ( ! empty( $alpha_layout['ptb'] ) && 'hide' != $alpha_layout['ptb'] ) {
				// Display selected template instead of page title bar.
				$alpha_layout['is_page_header'] = true;
				alpha_print_template( $alpha_layout['ptb'] );
				unset( $alpha_layout['is_page_header'] );

			} elseif ( ( ! empty( $alpha_layout['ptb'] ) && 'hide' == $alpha_layout['ptb'] ) || apply_filters( 'alpha_is_vendor_store', false ) ) {
				// Hide page title bar.

			} elseif ( class_exists( 'WooCommerce' ) && ( is_cart() || is_checkout() ) ) {

				$alpha_layout['show_breadcrumb'] = 'no';
				?>
				<div class="woo-page-header">
					<div class="<?php echo esc_attr( 'full' == $alpha_layout['wrap'] ? 'container' : $alpha_layout['wrap'] ); ?>">
						<ul class="breadcrumb">
							<li class="<?php echo is_cart() ? esc_attr( 'current' ) : ''; ?>">
								<a href="<?php echo esc_url( wc_get_cart_url() ); ?>"><?php esc_html_e( 'Shopping Cart', 'alpha' ); ?></a>
							</li>
							<li class="<?php echo is_checkout() && ! is_order_received_page() ? esc_attr( 'current' ) : ''; ?>">
								<i class="delimiter"></i>
								<a href="<?php echo esc_url( wc_get_checkout_url() ); ?>"><?php esc_html_e( 'Checkout', 'alpha' ); ?></a>
							</li>
							<li class="<?php echo is_order_received_page() ? esc_attr( 'current' ) : esc_attr( 'disable' ); ?>">
								<i class="delimiter"></i>
								<a href="#"><?php esc_html_e( 'Order Complete', 'alpha' ); ?></a>
							</li>
						</ul>
					</div>
				</div>
							<?php
			} else {
				// Show page header
				Alpha_Layout_Builder::get_instance()->setup_titles();
				$ptb_attr = ' class="page-header';
				if ( alpha_get_option( 'ptb_animation' ) ) {
					$ptb_attr .= ' page-header-animate';
				}

				$is_parallax = alpha_get_option( 'ptb_parallax' ) && ! empty( alpha_get_option( 'ptb_bg_image' ) );

				$ptb_attr .= '"';

				echo '<div' . $ptb_attr . '>';

				if ( $is_parallax ) {
					wp_enqueue_script( 'jquery-parallax' );
					echo '<div class="parallax" data-image-src="' . alpha_get_option( 'ptb_bg_image' ) . '">';
				}

				if ( $is_parallax ) {
					echo '</div>';
				}

				if ( ! $is_parallax && alpha_get_option( 'ptb_bg_image' ) ) {
					echo wp_get_attachment_image( attachment_url_to_postid( alpha_get_option( 'ptb_bg_image' ) ), 'full' );
				}

				?>
					<div class="page-title-bar">
						<div class="page-title-wrap">
				<?php if ( $alpha_layout['title'] ) : ?>
								<h2 class="page-title"><?php echo alpha_strip_script_tags( $alpha_layout['title'] ); ?></h2>
							<?php endif; ?>
							<?php if ( 'subtitle' == alpha_get_option( 'ptb_content' ) && $alpha_layout['subtitle'] ) : ?>
								<h3 class="page-subtitle"><?php echo alpha_strip_script_tags( $alpha_layout['subtitle'] ); ?></h3>
							<?php endif; ?>
						</div>
							<?php
							if ( 'breadcrumb' == alpha_get_option( 'ptb_content' ) ) {
								alpha_breadcrumb();
							} elseif ( 'search' == alpha_get_option( 'ptb_content' ) ) {
								alpha_search_form();
							}
							?>
					</div>
							<?php
							global $wp_filesystem;
							if ( empty( $wp_filesystem ) ) {
								require_once ABSPATH . '/wp-admin/includes/file.php';
								WP_Filesystem();
							}
							echo alpha_escaped( $wp_filesystem->get_contents( ALPHA_PATH . '/assets/images/shapes/shape' . alpha_get_option( 'ptb_divider' ) . '.svg' ) );

							?>
				</div>
							<?php
			}

			if ( ( empty( $alpha_layout['show_breadcrumb'] ) || 'no' != $alpha_layout['show_breadcrumb'] ) && 'breadcrumb' != alpha_get_option( 'ptb_content' ) ) {
				echo '<div class="breadcrumb-wrap">';
				alpha_breadcrumb();
				echo '</div>';
			}
		}
	}
}

if ( ! function_exists( 'alpha_set_avatar_size' ) ) {
	function alpha_set_avatar_size( $args ) {
		$args['size']   = 80;
		$args['width']  = 80;
		$args['height'] = 80;
		return $args;
	}
}

if ( ! function_exists( 'alpha_options_array_map_convert' ) ) {
	function alpha_options_array_map_convert( $option ) {
		if ( ! is_array( $option ) ) {
			return $option;
		}
		$ret = array();
		foreach ( $option as $key => $value ) {
			if ( '1' == $value ) {
				$ret[] = $key;
			}
		}
		return $ret;
	}
}

if ( ! function_exists( 'alpha_wc_count_per_page' ) ) {
	function alpha_wc_count_per_page() {
		global $alpha_layout;
		$count_select = apply_filters( 'alpha_products_count_select', alpha_get_option( 'products_count_select' ) );
		$ts           = ! empty( $alpha_layout['top_sidebar'] ) && 'hide' != $alpha_layout['top_sidebar'] && is_active_sidebar( $alpha_layout['top_sidebar'] );
		?>
		<div class="toolbox-item toolbox-show-count select-box">
			<label><?php esc_html_e( 'Show :', 'alpha' ); ?></label>
			<select name="count" class="count form-control">
				<?php
				if ( ! empty( $count_select ) ) {
					$count_select = explode( ',', str_replace( ' ', '', $count_select ) );
				} else {
					$count_select = array( '9', '_12', '24', '36' );
				}

				$current = alpha_loop_shop_per_page( $count_select );

				foreach ( $count_select as $count ) {
					$num = (int) str_replace( '_', '', $count );
					echo '<option value="' . $num . '" ' . selected( $num == $current, true, false ) . '>' . $num . '</option>';
				}
				?>
			</select>
			<?php
			$except = array( 'count' );
			// Keep query string vars intact
			foreach ( $_GET as $key => $val ) {
				if ( in_array( $key, $except ) ) {
					continue;
				}

				if ( is_array( $val ) ) {
					foreach ( $val as $inner_val ) {
						echo '<input type="hidden" name="' . esc_attr( $key ) . '[]" value="' . esc_attr( $inner_val ) . '" />';
					}
				} else {
					echo '<input type="hidden" name="' . esc_attr( $key ) . '" value="' . esc_attr( $val ) . '" />';
				}
			}
			?>
		</div>
		<?php
	}
}

/**
 * Get slider status class from settings array
 *
 * @since 4.0
 *
 * @param array $settings Slider settings array from elementor widget.
 *
 * @return string slider class
 */
if ( ! function_exists( 'alpha_get_slider_status_class' ) ) {
	function alpha_get_slider_status_class( $settings = array() ) {

		$class = '';
		// Nav & Dots
		if ( isset( $settings['nav_type'] ) && 'full' == $settings['nav_type'] ) {
			$class .= ' slider-nav-full';
		} else {
			if ( isset( $settings['nav_type'] ) && 'circle' == $settings['nav_type'] ) {
				$class .= ' slider-nav-circle';
			}
			if ( isset( $settings['nav_pos'] ) && 'top' == $settings['nav_pos'] ) {
				$class .= ' slider-nav-top';
			} elseif ( isset( $settings['nav_pos'] ) && 'bottom' == $settings['nav_pos'] ) {
				$class .= ' slider-nav-bottom';
			} elseif ( isset( $settings['nav_pos'] ) && 'inner' != $settings['nav_pos'] ) {
				$class .= ' slider-nav-outer';
			}
		}
		if ( isset( $settings['nav_hide'] ) && 'yes' == $settings['nav_hide'] ) {
			$class .= ' slider-nav-fade';
		}
		if ( isset( $settings['dots_skin'] ) && $settings['dots_skin'] ) {
			$class .= ' slider-dots-' . $settings['dots_skin'];
		} else {
			$class .= ' slider-dots-default';
		}
		if ( isset( $settings['dots_pos'] ) && 'inner' == $settings['dots_pos'] ) {
			$class .= ' slider-dots-inner';
		}
		if ( isset( $settings['dots_pos'] ) && 'outer' == $settings['dots_pos'] ) {
			$class .= ' slider-dots-outer';
		}
		if ( isset( $settings['fullheight'] ) && 'yes' == $settings['fullheight'] ) {
			$class .= ' slider-full-height';
		}
		if ( isset( $settings['box_shadow_slider'] ) && 'yes' == $settings['box_shadow_slider'] ) {
			$class .= ' slider-shadow';
		}

		if ( isset( $settings['slider_vertical_align'] ) && ( 'top' == $settings['slider_vertical_align'] ||
		'middle' == $settings['slider_vertical_align'] ||
		'bottom' == $settings['slider_vertical_align'] ||
		'same-height' == $settings['slider_vertical_align'] ) ) {

			$class .= ' slider-' . $settings['slider_vertical_align'];
		}

		return $class;
	}
}

/**
 * Get search form
 *
 * @since 4.0
 */
if ( ! function_exists( 'alpha_search_form' ) ) {
	function alpha_search_form( $args = array() ) {
		$args = wp_parse_args(
			$args,
			array(
				'type'             => 'classic',
				'toggle_type'      => 'overlap',
				'search_align'     => 'start',
				'fullscreen_skin'  => 'light',
				'where'            => '',
				'live_search'      => (bool) alpha_get_option( 'live_search' ),
				'search_post_type' => alpha_get_option( 'search_post_type' ),
				'icon'             => ALPHA_ICON_PREFIX . '-icon-search',
				'label'            => '',
				'placeholder'      => '',
			)
		);

		extract( $args );

		ob_start();
		$class = '';
		if ( 'toggle' == $type ) {
			$class .= ' hs-toggle hs-' . $toggle_type;
		}

		if ( $search_align ) {
			$class .= ' hs-' . $search_align;
		}
		$class .= ' ' . $fullscreen_skin . '-style';
		?>

	<div class="search-wrapper <?php echo esc_attr( $class ); ?>">
					<?php if ( 'toggle' == $type ) : ?>
		<a href="#" class="search-toggle" aria-label="<?php esc_html_e( 'Search', 'alpha' ); ?>">
			<i class="<?php echo esc_attr( $icon ); ?>"></i>
						<?php if ( $label ) : ?>
			<span><?php echo esc_html( $label ); ?></span>
			<?php endif; ?>
		</a>
		<?php endif; ?>

					<?php if ( 'fullscreen' == $toggle_type ) : ?>
		<div class="close-overlay"></div>
		<div class="search-form-wrapper">
			<div class="search-inner-wrapper">
				<div class="search-form">
		<?php endif; ?>
		<form action="<?php echo esc_url( home_url() ); ?>/" method="get" class="input-wrapper">
			<input type="hidden" name="post_type" value="<?php echo esc_attr( $search_post_type ); ?>"/>

			<input type="search" aria-label="<?php esc_attr_e( 'Search', 'alpha' ); ?>" class="form-control" name="s" placeholder="<?php echo esc_attr( $placeholder ); ?>" required="" autocomplete="off">

					<?php if ( $live_search ) : ?>
				<div class="live-search-list"></div>
			<?php endif; ?>

			<button class="btn btn-search" aria-label="<?php esc_attr_e( 'Search Button', 'alpha' ); ?>" type="submit">
				<i class="<?php echo esc_attr( $icon ); ?>"></i>
			</button>

					<?php if ( 'overlap' == $toggle_type ) : ?>
			<div class="hs-close">
				<a href="#">
					<span class="close-wrap">
						<span class="close-line close-line1"></span>
						<span class="close-line close-line2"></span>
					</span>
				</a>
			</div>
		<?php endif; ?>

		</form>
					<?php if ( 'fullscreen' == $toggle_type ) : ?>
					<div class="search-header">
						<?php esc_html_e( 'Hit enter to search or ESC to close', 'alpha' ); ?>
						<div class="hs-close">
							<a href="#">
								<span class="close-wrap">
									<span class="close-line close-line1"></span>
									<span class="close-line close-line2"></span>
								</span>
							</a>
						</div>
					</div>
				</div>
				<div class="search-container mt-8">
					<div class="scrollable">
						<div class="search-results">
						</div>
					</div>
				</div>
			</div>
		</div>
	<?php endif; ?>
	</div>

		<?php

		echo apply_filters( 'get_search_form', ob_get_clean() );
	}
}

/**
 * Ajax sign in/ sign up
 *
 * @since 4.0
 */

if ( ! function_exists( 'alpha_retrieve_account_html' ) ) {
	function alpha_retrieve_account_html() {
		?>
		<div class="login-popup" id="customer_login">
			<?php
			do_action( 'alpha_before_customer_login_form' );
			?>
			<div class="tab tab-nav-simple tab-nav-fill form-tab">
				<ul class="nav nav-tabs nav-fill" role="tablist">
					<li class="nav-item">
						<a href="signin" class="nav-link active" data-toggle="tab"><?php esc_html_e( 'Sign In', 'alpha' ); ?></a>
					</li>
					<li class="nav-item">
						<a href="signup" class="nav-link" data-toggle="tab"><?php esc_html_e( 'Sign Up', 'alpha' ); ?></a>
					</li>
				</ul>
				<div class="tab-content">
					<div class="tab-pane active" id="signin">
						<form class="alpha-form alpha-form-login login" method="post">

							<?php do_action( 'alpha_login_form_start' ); ?>

							<p class="alpha-form-row alpha-form-row--wide form-row form-row-wide">
								<label for="username"><?php esc_html_e( 'Username or email address', 'alpha' ); ?>&nbsp;<span class="required">*</span></label>
								<input type="text" class="alpha-Input alpha-Input--text input-text" name="username" id="username" autocomplete="username" required value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
							</p>
							<p class="alpha-form-row alpha-form-row--wide form-row form-row-wide">
								<label for="password"><?php esc_html_e( 'Password', 'alpha' ); ?>&nbsp;<span class="required">*</span></label>
								<input class="alpha-Input alpha-Input--text input-text" type="password" name="password" id="password" autocomplete="current-password" required />
							</p>

							<?php do_action( 'alpha_login_form' ); ?>

							<div class="form-row form-footer">
								<label class="alpha-form__label alpha-form__label-for-checkbox alpha-form-login__rememberme form-checkbox">
									<input class="alpha-form__input alpha-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <span><?php esc_html_e( 'Remember me', 'alpha' ); ?></span>
								</label>
								<p class="alpha-LostPassword lost_password">
									<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Lost your password?', 'alpha' ); ?></a>
								</p>
							</div>

							<?php wp_nonce_field( 'alpha-login', 'alpha-login-nonce' ); ?>
							<button type="submit" class="alpha-button button alpha-form-login__submit" name="login" value="<?php esc_attr_e( 'Sign In', 'alpha' ); ?>"><?php esc_html_e( 'Sign In', 'alpha' ); ?></button>

							<p class="submit-status"></p>

							<?php do_action( 'alpha_login_form_end' ); ?>

						</form>
					</div>

					<div class="tab-pane" id="signup">
						<form method="post" class="alpha-form alpha-form-login register" <?php do_action( 'alpha_register_form_tag' ); ?> >

							<?php do_action( 'alpha_register_form_start' ); ?>

							<p class="alpha-form-row alpha-form-row--wide form-row form-row-wide">
								<label for="reg_username"><?php esc_html_e( 'Username', 'alpha' ); ?>&nbsp;<span class="required">*</span></label>
								<input type="text" class="alpha-Input alpha-Input--text input-text" name="username" id="reg_username" autocomplete="username" required value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
							</p>

							<p class="alpha-form-row alpha-form-row--wide form-row form-row-wide">
								<label for="reg_email"><?php esc_html_e( 'Your Email address', 'alpha' ); ?>&nbsp;<span class="required">*</span></label>
								<input type="email" class="alpha-Input alpha-Input--text input-text" name="email" id="reg_email" autocomplete="email" required value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
							</p>

							<?php do_action( 'alpha_register_form' ); ?>

							<?php wp_nonce_field( 'alpha-register', 'alpha-register-nonce' ); ?>
							<button type="submit" class="alpha-Button alpha-button button alpha-form-register__submit" name="register" value="<?php esc_attr_e( 'Sign Up', 'alpha' ); ?>"><?php esc_html_e( 'Sign Up', 'alpha' ); ?></button>

							<p class="submit-status"></p>

							<?php do_action( 'alpha_register_form_end' ); ?>

						</form>
					</div>
				</div>
			</div>

			<?php do_action( 'alpha_after_customer_login_form' ); ?>
		</div>
		<?php
	}
}

if ( ! function_exists( 'alpha_ajax_account_form' ) ) {
	function alpha_ajax_account_form() {

		// phpcs:disable WordPress.Security.NonceVerification.NoNonceVerification

		if ( class_exists( 'WooCommerce' ) ) {
			wc_get_template( 'myaccount/form-login.php' );
		} else {
			function_exists( 'alpha_retrieve_account_html' ) &&
			alpha_retrieve_account_html();
		}

		// phpcs:enable
	}
}

// sign in ajax validate
if ( ! function_exists( 'alpha_account_signin_validate' ) ) {
	function alpha_account_signin_validate() {
		if ( class_exists( 'WooCommerce' ) ) {
			$filter_prefix = 'woocommerce';
			$nonce_value   = wc_get_var( $_REQUEST['woocommerce-login-nonce'], wc_get_var( $_REQUEST['_wpnonce'], '' ) );
		} else {
			$filter_prefix = 'alpha';
			$nonce_value   = isset( $_POST['_wpnonce'] ) ? $_POST['_wpnonce'] : '';
			$nonce_value   = isset( $_POST['alpha-login-nonce'] ) ? $_POST['alpha-login-nonce'] : $nonce_value;
		}
		$result = false;
		if ( wp_verify_nonce( $nonce_value, $filter_prefix . '-login' ) ) {
			try {
				$creds = array(
					'user_login'    => trim( $_POST['username'] ),
					'user_password' => $_POST['password'],
					'remember'      => isset( $_POST['rememberme'] ),
				);

				$validation_error = new WP_Error();
				$validation_error = apply_filters( $filter_prefix . '_process_login_errors', $validation_error, $_POST['username'], $_POST['password'] );

				if ( $validation_error->get_error_code() ) {
					echo json_encode(
						array(
							'loggedin' => false,
							'message'  => '<strong>' . esc_html__(
								'Error:',
								'alpha'
							) . '</strong> ' . $validation_error->get_error_message(),
						)
					);
					die();
				}

				if ( empty( $creds['user_login'] ) ) {
					echo json_encode(
						array(
							'loggedin' => false,
							'message'  => '<strong>' . esc_html__(
								'Error:',
								'alpha'
							) . '</strong> ' . esc_html__(
								'Username is required.',
								'alpha'
							),
						)
					);
					die();
				}

				// On multisite, ensure user exists on current site, if not add them before allowing login.
				if ( is_multisite() ) {
					$user_data = get_user_by( is_email( $creds['user_login'] ) ? 'email' : 'login', $creds['user_login'] );

					if ( $user_data && ! is_user_member_of_blog( $user_data->ID, get_current_blog_id() ) ) {
						add_user_to_blog( get_current_blog_id(), $user_data->ID, 'customer' );
					}
				}

				// Perform the login
				$user = wp_signon( apply_filters( $filter_prefix . '_login_credentials', $creds ), is_ssl() );
				if ( ! is_wp_error( $user ) ) {
					$result = true;
				}
			} catch ( Exception $e ) {
				$result = false;
			}
		}

		if ( $result ) {
			echo json_encode(
				array(
					'loggedin' => true,
					'message'  => esc_html__(
						'Login successful, redirecting...',
						'alpha'
					),
				)
			);
		} else {
			echo json_encode(
				array(
					'loggedin' => false,
					'message'  => esc_html__(
						'Wrong username or password.',
						'alpha'
					),
				)
			);
		}
		die();
	}
}

/**
 * Account signup validate
 *
 * @since 4.0
 */
if ( ! function_exists( 'alpha_account_signup_validate' ) ) {
	function alpha_account_signup_validate() {
		if ( class_exists( 'WooCommerce' ) ) {
			$filter_prefix = 'woocommerce';
		} else {
			$filter_prefix = 'alpha';
		}
		$nonce_value = isset( $_POST['_wpnonce'] ) ? $_POST['_wpnonce'] : '';
		$nonce_value = isset( $_POST[ $filter_prefix . '-register-nonce' ] ) ? $_POST[ $filter_prefix . '-register-nonce' ] : $nonce_value;
		$result      = false;

		if ( wp_verify_nonce( $nonce_value, $filter_prefix . '-register' ) ) {
			if ( class_exists( 'WooCommerce' ) ) {
				$username = 'no' == get_option( 'woocommerce_registration_generate_username' ) ? $_POST['username'] : '';
				$password = 'no' == get_option( 'woocommerce_registration_generate_password' ) ? $_POST['password'] : '';
				$email    = $_POST['email'];
			} else {
				$username = isset( $_POST['username'] ) ? $_POST['username'] : '';
				$password = isset( $_POST['password'] ) ? $_POST['password'] : '';
				$email    = $_POST['email'];
			}

			try {
				$validation_error = new WP_Error();
				$validation_error = apply_filters( $filter_prefix . '_process_registration_errors', $validation_error, $username, $password, $email );

				if ( $validation_error->get_error_code() ) {
					echo json_encode(
						array(
							'loggedin' => false,
							'message'  => $validation_error->get_error_message(),
						)
					);
					die();
				}

				if ( class_exists( 'WooCommerce' ) ) {
					$new_customer = wc_create_new_customer( sanitize_email( $email ), wc_clean( $username ), $password );

					if ( is_wp_error( $new_customer ) ) {
						echo json_encode(
							array(
								'loggedin' => false,
								'message'  => $new_customer->get_error_message(),
							)
						);
						die();
					}

					if ( apply_filters( 'woocommerce_registration_auth_new_customer', true, $new_customer ) ) {
						wc_set_customer_auth_cookie( $new_customer );
						$result = true;
					}
				} else {
					if ( empty( $username ) || empty( $email ) ) {
						echo json_encode(
							array(
								'loggedin' => false,
								'message'  => '<strong>' . esc_html__(
									'Error:',
									'alpha'
								) . '</strong> ' . esc_html__(
									'Username and Email both are required.',
									'alpha'
								),
							)
						);
						die();
					}

					$new_customer_data = apply_filters(
						'alpha_new_customer_data',
						array(
							'user_login' => $username,
							'user_pass'  => wp_generate_password(),
							'user_email' => $email,
							'role'       => 'customer',
						)
					);

					$customer_id = wp_insert_user( $new_customer_data );

					if ( $customer_id ) {
						wp_set_current_user( $customer_id );
						wp_set_auth_cookie( $customer_id, true );
						$result = true;
					}
				}
			} catch ( Exception $e ) {
				$result = false;
			}
		}

		if ( $result ) {
			echo json_encode(
				array(
					'loggedin' => true,
					'message'  => esc_html__(
						'Register successful, redirecting...',
						'alpha'
					),
				)
			);
		} else {
			echo json_encode(
				array(
					'loggedin' => false,
					'message'  => esc_html__(
						'Register failed.',
						'alpha'
					),
				)
			);
		}
		die();
	}
}

/**
 * Get excerpt
 *
 * @since 4.0
 */
if ( ! function_exists( 'alpha_get_excerpt' ) ) {
	function alpha_get_excerpt( $post, $excerpt_length = 45, $excerpt_type = 'words', $readmore_btn = '' ) {
		if ( has_excerpt( $post ) ) {
			echo alpha_trim_description( wp_strip_all_tags( get_the_excerpt( $post ), true ), $excerpt_length, $excerpt_type ) . alpha_escaped( $readmore_btn );
		} elseif ( strpos( $post->post_content, '<!--more-->' ) ) {
			echo apply_filters( 'the_content', alpha_trim_description( get_the_content( '' ), $excerpt_length, $excerpt_type ) ) . alpha_escaped( $readmore_btn );
		} else {
			$content = alpha_trim_description( get_the_content(), $excerpt_length, $excerpt_type );
			if ( $content ) {
				echo alpha_escaped( $content . $readmore_btn );
			}
		}
	}
}
