<?php
/**
 * Theme Actions & Filters
 *
 * @author     Andon
 * @package    Alpha FrameWork
 * @subpackage Theme
 * @since      4.0
 */
defined( 'ABSPATH' ) || die;

add_action( 'admin_head', 'alpha_print_favicon' );

// Display Page Transition Effect
add_action( 'alpha_page_transition', 'alpha_page_transition' );

// The main tag's class
add_filter( 'alpha_main_class', 'alpha_add_main_class' );

// Nothing found result
add_action( 'alpha_template_nothing_found', 'alpha_template_nothing_found', 10, 2 );

// Google fonts
add_filter( 'alpha_google_fonts', 'alpha_google_fonts' );

// Posts
add_filter( 'alpha_post_types', 'alpha_theme_post_types', 10, 2 );
add_filter( 'navigation_markup_template', 'alpha_pager_posts' );

// Mobile sticky bar
add_action( 'alpha_after_page_wrapper', 'alpha_print_mobile_bar' );

// Single Product Layouts
add_filter( 'alpha_sp_types', 'alpha_single_product_types_extend', 10, 2 );

// Dark Skin
add_filter( 'body_class', 'alpha_add_dark_body_class' );

// Default Post Options
add_filter( 'alpha_post_loop_default_args', 'alpha_post_loop_default' );

if ( ! function_exists( 'alpha_print_favicon' ) ) {
	function alpha_print_favicon() {
		$favicon = alpha_get_option( 'site_icon' );
		if ( ! empty( $favicon['url'] ) ) {
			echo '<link rel="shortcut icon" href="' . esc_url( $favicon['url'] ) . '" type="image/x-icon" />';
		}
	}
}

if ( ! function_exists( 'alpha_page_transition' ) ) {
	function alpha_page_transition() {
		$page_trans = alpha_get_option( 'page_transition' );
		if ( $page_trans ) :
			?>
			<div class="loading-screen" data-effect="<?php echo esc_attr( $page_trans ); ?>">
				<?php
				if ( 'slide' == $page_trans ) {
					echo '<div class="reveal"></div>';
				}
				?>
				<?php alpha_preloader(); ?>
			</div>
			<?php
		else :
			alpha_preloader();
		endif;
	}
}

if ( ! function_exists( 'alpha_add_main_class' ) ) {
	function alpha_add_main_class( $classes ) {
		return $classes;
	}
}

if ( ! function_exists( 'alpha_preloader' ) ) {
	function alpha_preloader() {
		$preloader = alpha_get_option( 'preloader' );
		if ( $preloader ) :
			?>
			<div class="loading-overlay <?php echo esc_attr( $preloader ); ?>">
				<div class="bounce-loader">
					<div class="loader loader-1"></div>
					<div class="loader loader-2"></div>
					<?php if ( 'preloader-3' != $preloader ) : ?>
					<div class="loader loader-3"></div>
					<?php endif; ?>
					<?php if ( 'preloader-4' == $preloader ) : ?>
					<div class="loader loader-4"></div>
					<?php endif; ?>
				</div>
			</div>
			<?php
		endif;
	}
}

if ( ! function_exists( 'alpha_template_nothing_found' ) ) {
	function alpha_template_nothing_found( $no_heading, $no_description ) {

		if ( defined( 'ALPHA_CORE_INC_URI' ) ) {
			wp_enqueue_style( 'alpha-alert', ALPHA_CORE_INC_URI . '/widgets/alert/alert' . ( is_rtl() ? '-rtl' : '' ) . '.min.css', array(), ALPHA_CORE_VERSION );
		}

		ob_start();
		?>
		<h2 class="entry-title">
			<?php
			if ( empty( $no_heading ) ) {
				esc_html_e( 'Nothing Found', 'alpha' );
			} else {
				echo esc_html( $no_heading );
			}
			?>
		</h2>

		<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
			<p class="alert alert-light alert-info">
				<?php
				printf(
					// translators: %1$s represents open tag of admin url to create new, %2$s represents close tag.
					esc_html__( 'Ready to publish your first post? %1$sGet started here%2$s.', 'alpha' ),
					sprintf( '<a href="%1$s" target="_blank">', esc_url( admin_url( 'post-new.php' . '?post_type=' . get_post_type() ) ) ),
					'</a>'
				);
				?>
			</p>
		<?php elseif ( is_search() ) : ?>
			<p class="alert alert-light alert-info alert-outline"><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with different keywords.', 'alpha' ); ?></p>
		<?php else : ?>
			<p class="alert alert-light alert-info alert-outline">
				<?php
				if ( empty( $no_description ) ) {
					esc_html_e( 'It seems we can\'t find what you\'re looking for. Perhaps searching can help.', 'alpha' );
				} else {
					echo alpha_strip_script_tags( $no_description );
				}
				?>
			</p>
		<?php endif; ?>
		<?php
		echo ob_get_clean();
	}
}

if ( ! function_exists( 'alpha_google_fonts' ) ) {
	function alpha_google_fonts( $fonts ) {
		return  array( 'typo_default', 'typo_heading', 'typo_custom1', 'typo_custom2', 'typo_custom3' );
	}
}


if ( ! function_exists( 'alpha_theme_post_types' ) ) {
	/**
	 * Add theme's post types
	 *
	 * @since 4.0.0
	 */
	function alpha_theme_post_types( $types, $src ) {
		return 'theme' == $src ? array(
			'default'     => ALPHA_ASSETS . '/images/options/posts/post-1.jpg',
			'bordered'    => ALPHA_ASSETS . '/images/options/posts/post-2.jpg',
			'boxed'       => ALPHA_ASSETS . '/images/options/posts/post-3.jpg',
			'classic'     => ALPHA_ASSETS . '/images/options/posts/post-4.jpg',
			'modern'      => ALPHA_ASSETS . '/images/options/posts/post-5.jpg',
			'list'        => ALPHA_ASSETS . '/images/options/posts/post-6.jpg',
			'mask'        => ALPHA_ASSETS . '/images/options/posts/post-7.jpg',
			'categorized' => ALPHA_ASSETS . '/images/options/posts/post-8.jpg',
			'widget'      => ALPHA_ASSETS . '/images/options/posts/post-9.jpg',
		) : array(
			'default'     => 'assets/images/posts/post-1.jpg',
			'bordered'    => 'assets/images/posts/post-2.jpg',
			'boxed'       => 'assets/images/posts/post-3.jpg',
			'classic'     => 'assets/images/posts/post-4.jpg',
			'modern'      => 'assets/images/posts/post-5.jpg',
			'list'        => 'assets/images/posts/post-6.jpg',
			'mask'        => 'assets/images/posts/post-7.jpg',
			'categorized' => 'assets/images/posts/post-8.jpg',
			'widget'      => 'assets/images/posts/post-9.jpg',
		);
	}
}

if ( ! function_exists( 'alpha_single_product_types_extend' ) ) {
	function alpha_single_product_types_extend( $types, $location ) {
		if ( 'layout' == $location ) {
			return array(
				''           => esc_html__( 'Default', 'alpha' ),
				'horizontal' => esc_html__( 'Horizontal Thumbs', 'alpha' ),
				'vertical'   => esc_html__( 'Vertical Thumbs', 'alpha' ),
				'builder'    => esc_html__( 'Use Builder', 'alpha' ),
			);
		} elseif ( 'theme' == $location ) {
			return array(
				'horizontal' => esc_html__( 'Horizontal Thumbs', 'alpha' ),
				'vertical'   => esc_html__( 'Vertical Thumbs', 'alpha' ),
			);
		} elseif ( 'hooks' == $location ) {
			return array(
				'horizontal' => true,
				'vertical'   => true,
			);
		}
		return array(
			''           => esc_html__( 'Default', 'alpha' ),
			'horizontal' => esc_html__( 'Horizontal Thumbs', 'alpha' ),
			'vertical'   => esc_html__( 'Vertical Thumbs', 'alpha' ),
		);
	}
}

if ( ! function_exists( 'alpha_pager_posts' ) ) {
	function alpha_pager_posts() {

		$post_type = get_post_type();

		$post_type_object = get_post_type_object( $post_type );

		$template = '
		<nav class="navigation %1$s" aria-label="%4$s">
			<h2 class="screen-reader-text">%2$s</h2>
			<div class="nav-links">%3$s</div>' .
			'<a class="post-nav-blog ' . ALPHA_ICON_PREFIX . '-icon-grid" href="' . esc_url( get_post_type_archive_link( $post_type ) ) . '" title="' . $post_type_object->labels->all_items . '"></a>' .
		'</nav>';

		return $template;
	}
}

if ( ! function_exists( 'alpha_add_dark_body_class' ) ) {
	function alpha_add_dark_body_class( $classes ) {
		if ( alpha_get_option( 'dark_skin' ) ) {
			$classes[] = 'alpha-dark';
		}
		return $classes;
	}
}

if ( ! function_exists( 'alpha_post_loop_default' ) ) {
	function alpha_post_loop_default( $args ) {
		return array_merge(
			$args,
			array(
				'type'            => alpha_get_option( $args['cpt'] . '_type' ),
				'overlay'         => alpha_get_option( $args['cpt'] . '_overlay' ),
				'excerpt_type'    => alpha_get_option( 'post' == $args['cpt'] ? 'excerpt_type' : $args['cpt'] . '_excerpt_type' ),
				'excerpt_length'  => alpha_get_option( 'post' == $args['cpt'] ? 'excerpt_length' : $args['cpt'] . '_excerpt_length' ),
				'read_more_label' => 'post' != $args['cpt'] ? alpha_get_option( $args['cpt'] . '_read_more_label' ) : esc_html__( 'Read More', 'alpha' ) . ' <i class="' . ALPHA_ICON_PREFIX . '-icon-long-arrow-right"></i>',
			)
		);
	}
}

if ( ! function_exists( 'alpha_add_body_class' ) ) {
	/**
	 * Add classes to body
	 *
	 * @since 4.0
	 *
	 * @param array[string] $classes
	 *
	 * @return array[string] $classes
	 */
	function alpha_add_body_class( $classes ) {
		global $alpha_layout;

		// Site Layout
		if ( 'full' != alpha_get_option( 'site_type' ) ) { // Boxed or Framed
			$classes[] = 'site-boxed';
		}

		// Page Type
		$layout = alpha_get_page_layout();
		if ( false !== strpos( $layout, 'archive_' . ALPHA_NAME . '_portfolio' ) || false !== strpos( $layout, 'archive_' . ALPHA_NAME . '_member' ) ) {
			$classes[] = 'alpha-archive-post-layout';
		}
		$classes[] = 'alpha-' . str_replace( '_', '-', $layout ) . '-layout';

		// Header Position
		$header = false;
		if ( alpha_get_feature( 'fs_pb_elementor' ) && defined( 'ELEMENTOR_VERSION' ) && isset( $alpha_layout['header'] ) && ! empty( get_post_meta( $alpha_layout['header'], '_elementor_data', true ) ) ) {
			$header = $alpha_layout['header'];
		}
		if ( ALPHA_NAME . '_template' == get_post_type() && 'header' == get_post_meta( get_the_ID(), ALPHA_NAME . '_template_type', true ) ) {
			$header = get_the_ID();
		}
		if ( $header ) {
			$settings = get_post_meta( $header, '_elementor_page_settings', true );
			if ( ! empty( $settings['alpha_header_pos'] ) ) {

				wp_enqueue_script( 'alpha-sidebar' );
				wp_enqueue_script( 'alpha-sticky-lib' );

				$classes[] = 'side-header';

				if ( ! empty( $settings['alpha_side_header_breakpoint'] ) ) {
					$classes[] = 'side-on-' . $settings['alpha_side_header_breakpoint'];
				}
			}
		}

		// Disable Mobile Slider
		if ( alpha_get_option( 'mobile_disable_slider' ) ) {
			$classes[] = 'alpha-disable-mobile-slider';
		}

		// Disable Mobile Animation
		if ( alpha_get_option( 'mobile_disable_animation' ) ) {
			$classes[] = 'alpha-disable-mobile-animation';
		}

		if ( is_customize_preview() ) {
			$classes[] = 'alpha-disable-animation';
		}

		// Add single-product-page or shop-page to body class
		if ( alpha_is_product() ) {
			$classes[] = 'single-product-page';
		} elseif ( alpha_is_shop() ) {
			$classes[] = 'product-archive-page';
		}

		// @start feature: fs_plugin_woocommerce
		if ( class_exists( 'WooCommerce' ) && wc_get_page_id( 'compare' ) == get_the_ID() ) {
			$classes[] = 'compare-page';
		}
		// @end feature: fs_plugin_woocommerce

		global $alpha_layout;

		$post_style_type = isset( $alpha_layout['post_style_type'] ) ? $alpha_layout : '';

		// Category Filter
		if ( is_archive() && 'post' == get_post_type() && alpha_get_option( 'posts_filter' ) ) {
			$classes[] = 'breadcrumb-divider-active';
		}

		if ( alpha_get_option( 'rounded_skin' ) ) {
			$classes[] = 'alpha-rounded-skin';
		}

		if ( is_admin_bar_showing() ) {
			$classes[] = 'alpha-adminbar';
		}
		if ( defined( 'ALPHA_FRAMEWORK_VENDORS' ) ) {
			$classes[] = 'alpha-use-vendor-plugin';
		}
		return $classes;
	}
}
