<?php
/**
 * Alpha FrameWork Assets Extend Class
 *
 * Enqueue framework assets including css, js and images.
 *
 * @author     Andon
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      1.0
 */
defined( 'ABSPATH' ) || die;

class Alpha_Assets_Extend extends Alpha_Base {

	/**
	 * Constructor
	 *
	 * @since 1.0
	 * @access public
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'register_scripts' ), 2 );
		add_action( 'wp_footer', array( $this, 'enqueue_theme_js_css' ) );
	}
	/**
	 * Register styles and scripts.
	 *
	 * @since 1.0
	 */
	public function register_scripts() {
		// Styles
		wp_register_style( 'framework-icons', ALPHA_ASSETS . '/vendor/wpalpha-icons/css/icons.min.css', array(), ALPHA_VERSION );
	}

	/**
	 * Enqueue theme js at last.
	 *
	 * @since 1.2.0
	 */
	public function enqueue_theme_js_css() {
		// Framework Icon
		wp_enqueue_style( 'framework-icons' );
		// Alert Style
		if ( defined( 'ALPHA_CORE_INC_URI' ) ) {
		wp_enqueue_style( 'alpha-alert', ALPHA_CORE_INC_URI . '/widgets/alert/alert' . ( is_rtl() ? '-rtl' : '' ) . '.min.css', array(), ALPHA_CORE_VERSION );
		}

		$layout = alpha_get_page_layout();
		if ( 'single_' == substr( $layout, 0, 7 ) && defined( 'ALPHA_CORE_INC_URI' ) ) {
			// Social Icon
			wp_enqueue_style( 'alpha-share', ALPHA_CORE_INC_URI . '/widgets/share/share' . ( is_rtl() ? '-rtl' : '' ) . '.min.css', array(), ALPHA_CORE_VERSION );
		}
	}
}


Alpha_Assets_Extend::get_instance();
