<?php

/**
 * Setup wizard
 */

// Plugins
add_filter( 'alpha_plugin', 'alpha_additional_plugins' );

// Demos
add_filter( 'alpha_demo_types', 'alpha_addtional_demos' );

if ( ! function_exists( 'alpha_additional_plugins' ) ) {
	function alpha_additional_plugins( $plugins ) {
		$plugins[2]['required'] = false;
		$plugins                = array_merge(
			$plugins,
			array(
				array(
					'name'       => 'Advanced Custom Fields',
					'slug'       => 'advanced-custom-fields',
					'required'   => false,
					'url'        => 'advanced-custom-fields/acf.php',
					'image_url'  => ALPHA_ASSETS . '/images/admin/plugins/acf.png',
					'visibility' => 'setup_wizard',
				),
				array(
					'name'       => 'Essential Grid',
					'slug'       => 'essential-grid',
					'required'   => false,
					'url'        => 'essential-grid/essential-grid.php',
					'image_url'  => ALPHA_ASSETS . '/images/admin/plugins/essential-grid.png',
					'visibility' => 'setup_wizard',
				),
				array(
					'name'       => 'LearnPress',
					'slug'       => 'learnpress',
					'required'   => false,
					'url'        => 'learnpress/learnpress.php',
					'image_url'  => ALPHA_ASSETS . '/images/admin/plugins/learnpress.png',
					'visibility' => 'setup_wizard',
				),
				array(
					'name'       => 'Modern Events Calendar Lite',
					'slug'       => 'modern-events-calendar-lite',
					'required'   => false,
					'url'        => 'modern-events-calendar-lite/modern-events-calendar-lite.php',
					'image_url'  => ALPHA_ASSETS . '/images/admin/plugins/modern-events-calendar.png',
					'visibility' => 'setup_wizard',
				),
				array(
					'name'       => 'Post Types Unlimited',
					'slug'       => 'post-types-unlimited',
					'required'   => false,
					'url'        => 'post-types-unlimited/post-types-unlimited.php',
					'image_url'  => ALPHA_ASSETS . '/images/admin/plugins/unlimited.png',
					'visibility' => 'setup_wizard',
				),
				array(
					'name'       => 'Slider Revolution',
					'slug'       => 'revslider',
					'required'   => false,
					'url'        => 'revslider/revslider.php',
					'image_url'  => ALPHA_ASSETS . '/images/admin/plugins/revslider.png',
					'visibility' => 'setup_wizard',
				),
				array(
					'name'       => 'The Events Calendar',
					'slug'       => 'the-events-calendar',
					'required'   => false,
					'url'        => 'the-events-calendar/the-events-calendar.php',
					'image_url'  => ALPHA_ASSETS . '/images/admin/plugins/events-calendar.png',
					'visibility' => 'setup_wizard',
				),
				array(
					'name'       => 'WPForms Lite',
					'slug'       => 'wpforms-lite',
					'required'   => false,
					'url'        => 'wpforms-lite/wpforms.php',
					'image_url'  => ALPHA_ASSETS . '/images/admin/plugins/wpform.png',
					'visibility' => 'setup_wizard',
				),
				array(
					'name'       => 'YITH Woocommerce Wishlist',
					'slug'       => 'yith-woocommerce-wishlist',
					'required'   => false,
					'version'    => '3.0.20',
					'image_url'  => ALPHA_ASSETS . '/images/admin/plugins/yith_wishlist.png',
					'url'        => 'yith-woocommerce-wishlist/init.php',
					'visibility' => 'setup_wizard',
				),
			)
		);
		return $plugins;
	}
}

if ( ! function_exists( 'alpha_addtional_demos' ) ) {
	function alpha_addtional_demos() {
		return array(
			'main'                => array(
				'alt'     => 'Main',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/main.jpg',
				'filter'  => 'business',
				'plugins' => array( 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'corporate'           => array(
				'alt'     => 'Corporate',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/corporate.jpg',
				'filter'  => 'business',
				'plugins' => array( 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'farm-store'          => array(
				'alt'     => 'Farm Store',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/farm-store.jpg',
				'filter'  => 'shop',
				'plugins' => array( 'woocommerce', 'wpforms-lite', 'yith-woocommerce-wishlist' ),
				'editors' => array( 'elementor' ),
			),
			'health-coach'        => array(
				'alt'       => 'Health Coach',
				'img'       => ALPHA_ASSETS . '/images/admin/setup-wizard/health-coach.jpg',
				'filter'    => 'fitness',
				'plugins'   => array( 'woocommerce', 'revslider', 'the-events-calendar', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'revslider' => array( 'slider-1.zip' ),
				'editors'   => array( 'elementor' ),
			),
			'photography'         => array(
				'alt'       => 'Photography',
				'img'       => ALPHA_ASSETS . '/images/admin/setup-wizard/photography.jpg',
				'filter'    => 'other',
				'plugins'   => array( 'revslider', 'wpforms-lite' ),
				'revslider' => array( 'slider-1.zip' ),
				'editors'   => array( 'elementor' ),
			),
			'yoga'                => array(
				'alt'     => 'Yoga',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/yoga.jpg',
				'filter'  => 'fitness',
				'plugins' => array( 'advanced-custom-fields', 'post-types-unlimited', 'modern-events-calendar-lite', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'build'               => array(
				'alt'       => 'Build',
				'img'       => ALPHA_ASSETS . '/images/admin/setup-wizard/build.jpg',
				'filter'    => 'business',
				'plugins'   => array( 'revslider', 'wpforms-lite' ),
				'revslider' => array( 'slider-3.zip' ),
				'editors'   => array( 'elementor' ),
			),
			'fashion'             => array(
				'alt'     => 'Fashion',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/fashion.jpg',
				'filter'  => 'shop',
				'plugins' => array( 'woocommerce', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'cannabis'            => array(
				'alt'     => 'Cannabis',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/cannabis.jpg',
				'filter'  => 'shop',
				'plugins' => array( 'woocommerce', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'medical'             => array(
				'alt'     => 'Clinic',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/medical.jpg',
				'filter'  => 'business',
				'plugins' => array( 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'clean-home'          => array(
				'alt'     => 'Clean Home',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/clean-home.jpg',
				'filter'  => 'clean',
				'plugins' => array( 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'education'           => array(
				'alt'       => 'Education',
				'img'       => ALPHA_ASSETS . '/images/admin/setup-wizard/education.jpg',
				'filter'    => 'other',
				'plugins'   => array( 'learnpress', 'revslider', 'the-events-calendar', 'wpforms-lite' ),
				'revslider' => array( 'slider-1.zip' ),
				'editors'   => array( 'elementor' ),
			),
			'real-estate'         => array(
				'alt'     => 'Real Estate',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/real-estate.jpg',
				'filter'  => 'other',
				'plugins' => array( 'advanced-custom-fields', 'essential-grid', 'post-types-unlimited', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'restaurant'          => array(
				'alt'     => 'Restaurant',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/restaurant.jpg',
				'filter'  => 'food',
				'plugins' => array( 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'resume'              => array(
				'alt'     => 'Resume',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/resume.jpg',
				'filter'  => 'other',
				'plugins' => array( 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'dentist'             => array(
				'alt'     => 'Dentist',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/dentist.jpg',
				'filter'  => 'business',
				'plugins' => array( 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'furniture'           => array(
				'alt'     => 'Furniture',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/furniture.jpg',
				'filter'  => 'shop',
				'plugins' => array( 'woocommerce', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'gym'                 => array(
				'alt'     => 'Gym',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/gym.jpg',
				'filter'  => 'fitness',
				'plugins' => array( 'advanced-custom-fields', 'post-types-unlimited', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'beauty'              => array(
				'alt'     => 'Beauty',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/beauty.jpg',
				'filter'  => 'shop',
				'plugins' => array( 'woocommerce', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'shoes'               => array(
				'alt'     => 'Shoes',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/shoes.jpg',
				'filter'  => 'shop',
				'plugins' => array( 'woocommerce', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'tea'                 => array(
				'alt'     => 'Tea',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/tea.jpg',
				'filter'  => 'food',
				'plugins' => array( 'woocommerce', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'jewelry'             => array(
				'alt'     => 'Jewelry',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/jewelry.jpg',
				'filter'  => 'shop',
				'plugins' => array( 'woocommerce', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'fashion-2'           => array(
				'alt'     => 'Fashion 2',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/fashion-2.jpg',
				'filter'  => 'shop',
				'plugins' => array( 'woocommerce', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'landing-product'     => array(
				'alt'     => 'Landing Product',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/landing-product.jpg',
				'filter'  => 'other',
				'plugins' => array( 'woocommerce', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'app'                 => array(
				'alt'     => 'App Landing',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/app.jpg',
				'filter'  => 'other',
				'plugins' => array( 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'burger'              => array(
				'alt'     => 'Burger',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/burger.jpg',
				'filter'  => 'shop',
				'plugins' => array( 'woocommerce', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'wine'                => array(
				'alt'     => 'Wine',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/wine.jpg',
				'filter'  => 'shop',
				'plugins' => array( 'advanced-custom-fields', 'woocommerce', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'business-consulting' => array(
				'alt'     => 'Business Consulting',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/business-consulting.jpg',
				'filter'  => 'business',
				'plugins' => array( 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'law-firm'            => array(
				'alt'     => 'Law Firm',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/law-firm.jpg',
				'filter'  => 'business',
				'plugins' => array( 'post-types-unlimited', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
			'babycare'            => array(
				'alt'     => 'Babycare',
				'img'     => ALPHA_ASSETS . '/images/admin/setup-wizard/babycare.jpg',
				'filter'  => 'shop',
				'plugins' => array( 'woocommerce', 'yith-woocommerce-wishlist', 'wpforms-lite' ),
				'editors' => array( 'elementor' ),
			),
		);
	}
}
