<?php
/**
 * Alpha Yith Gift Card
 *
 * @author     D-THEMES
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      1.0
 */
if ( ! class_exists( 'Alpha_Gift_Card' ) ) {

	class Alpha_Gift_Card extends Alpha_Base {

		/**
		 * Constructor
		 *
		 * @since 1.0
		 */
		public function __construct() {
			add_action( 'wp_footer', array( $this, 'enqueue_style' ), 25 );
			add_filter( 'ywgc_remove_gift_card_text', array( $this, 'get_remove_gift_card_text' ), 10 );
			if ( class_exists( 'YITH_YWGC_Frontend' ) ) {
				remove_action( 'wp', array( YITH_YWGC_Frontend::get_instance(), 'yith_ywgc_remove_image_zoom_support' ), 100 );
			}
		}

		/**
		 * Enqueue styles
		 *
		 * @since 1.0
		 */
		public function enqueue_style() {
			wp_enqueue_style( 'alpha-yith-gift-card-style', ALPHA_PLUGINS_URI . '/yith-gift-card/yith-gift-card' . ( is_rtl() ? '-rtl' : '' ) . '.min.css', array( 'alpha-theme' ), ALPHA_VERSION );
		}

		/**
		 * Change text of remove gift card button
		 *
		 * @since 1.0
		 */
		public function get_remove_gift_card_text() {
			return esc_html__( 'Remove', 'alpha' );
		}
	}
}

Alpha_Gift_Card::get_instance();
