<?php

use Elementor\Controls_Manager;
use Elementor\Alpha_Controls_Manager;
add_action(
	'elementor/element/' . ALPHA_NAME . '_widget_table/section_table_body/after_section_end',
	function ( $self ) {
		$self->start_controls_section(
			'section_table_style',
			array(
				'label' => esc_html__( 'General', 'alpha-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
			$self->add_responsive_control(
				'table_width',
				array(
					'label'      => esc_html__( 'Table Width', 'alpha-core' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array(
						'px',
						'%',
						'rem',
					),
					'range'      => array(
						'px' => array(
							'step' => 1,
							'min'  => 320,
							'max'  => 1920,
						),
					),
					'selectors'  => array(
						'.elementor-element-{{ID}} .widget-table' => 'width: {{SIZE}}{{UNIT}};',
					),
				)
			);

		$self->end_controls_section();
	}
);