<?php
defined( 'ABSPATH' ) || die;

/**
 * Sticky Column
 *
 * @author     Andon
 * @package    WP Alpha Core FrameWork
 * @subpackage Core
 * @since      4.1
 */

use Elementor\Controls_Manager;

if ( ! class_exists( 'Alpha_Sticky_Column_Elementor_Widget_Addon' ) ) {
	class Alpha_Sticky_Column_Elementor_Widget_Addon extends Alpha_Base {
		/**
		 * Constructor
		 *
		 * @since 4.0
		 */
		public function __construct() {
			// Add sticky column controls
			add_action( 'alpha_elementor_column_addon_controls', array( $this, 'add_sticky_column_controls' ), 15, 2 );
			// Update column addon content template
			add_action( 'alpha_elementor_column_addon_content_template', array( $this, 'update_column_addon_content_template' ) );
			// Update column render
			add_action( 'alpha_elementor_column_render', array( $this, 'update_column_render' ), 10, 2 );
		}
		/**
		 * Add sticky column controls to column element
		 *
		 * @since 4.0
		 */
		public function add_sticky_column_controls( $self, $condition_value ) {
			$self->update_control(
				'use_as',
				array(
					'separator' => 'before',
				)
			);
			$self->add_control(
				'sticky_column',
				array(
					'type'        => Controls_Manager::SWITCHER,
					'label'       => esc_html__( 'Sticky Column', 'alpha-core' ),
					'default'     => 'no',
					'description' => esc_html__( 'Controls column to make sticky or not in a section.', 'alpha-core' ),
				),
				array(
					'position' => array(
						'at' => 'before',
						'of' => $condition_value,
					),
				)
			);

			$self->add_responsive_control(
				'sticky_column_top',
				array(
					'type'      => Controls_Manager::NUMBER,
					'label'     => esc_html__( 'Top Space on Sticky', 'alpha-core' ),
					'default'   => '0',
					'selectors' => array(
						'{{WRAPPER}}.elementor-column' . ( alpha_elementor_if_dom_optimization() ? ' > .elementor-widget-wrap' : ' > .elementor-column-wrap' ) => 'top: {{SIZE}}px',
					),
					'condition' => array(
						'sticky_column' => 'yes',
					),
				),
				array(
					'position' => array(
						'at' => 'before',
						'of' => $condition_value,
					),
				)
			);
		}

		/**
		 * Update column addon content template
		 *
		 * @since 4.0
		 */
		public function update_column_addon_content_template( $self ) {
			?>
			<#
				if('yes' == settings.sticky_column) {
					wrapper_attrs += ' data-sticky-column="true"';
				}
			#>
			<?php
		}

		/**
		 * Update column render
		 *
		 * @since 4.0
		 */
		public function update_column_render( $self, $settings ) {
			$self->add_render_attribute(
				array(
					'_wrapper' => array(
						'class' => ( 'yes' == $settings['sticky_column'] ) ? 'alpha-sticky-column' : '',
					),
				)
			);
		}
	}
}

/**
 * Create instance
 *
 * @since 4.1
 */
Alpha_Sticky_Column_Elementor_Widget_Addon::get_instance();
