<?php
defined( 'ABSPATH' ) || die;

/**
 * Alpha Posts Grid Widget Render
 *
 * @author     Andon
 * @package    WP Alpha Core FrameWork
 * @subpackage Core
 * @since      4.1
 */

$default_atts = array(
	'shortcode_type'       => '',
	'shortcode'            => '',
	'builder_id'           => '',
	'list_builder_id'      => '',
	'source'               => '',
	'post_type'            => '',
	'post_tax'             => '',
	'post_terms'           => '',
	'tax'                  => '',
	'terms'                => '',
	'count'                => '',
	'orderby'              => '',
	'orderby_term'         => '',
	'orderway'             => '',
	'cats'                 => '',

	'view'                 => 'grid',
	'row_cnt'              => 1,
	'col_cnt'              => 4,
	'col_cnt_xl'           => '',
	'col_cnt_tablet'       => '',
	'col_cnt_mobile'       => '',
	'col_cnt_min'          => '',
	'list_col_cnt'         => '',
	'col_sp'               => '',
	'creative_cols'        => '',
	'creative_cols_tablet' => '',
	'creative_cols_mobile' => '',
	'items_list'           => '',
	'loadmore_type'        => '',
	'loadmore_label'       => '',
	'filter_cat_w'         => '',
	'filter_cat'           => '',
	'filter_cat_tax'       => '',
	'show_all_filter'      => '',
	'thumbnail_size'       => '',
	'post_found_nothing'   => '',

	'posts_wrap_cls'       => '',

	'is_related'           => false,
);
extract( // @codingStandardsIgnoreLine
	shortcode_atts(
		$default_atts,
		$atts
	)
);

if ( 'archive' == $shortcode_type ) {
	global $wp_query;
	if ( isset( $wp_query->query_vars ) && ! empty( $wp_query->query_vars['post_type'] ) ) {
		$post_type = $wp_query->query_vars['post_type'];
	} else {
		$post_type = get_post_type();
	}
	if ( ! $post_type ) {
		$post_type = 'post';
	}
	if ( 'product' == $post_type && isset( $_COOKIE[ ALPHA_NAME . '_gridcookie' ] ) && 'list' == $_COOKIE[ ALPHA_NAME . '_gridcookie' ] && ! empty( $list_builder_id ) ) {
		$builder_id = $list_builder_id;
		if ( empty( $list_col_cnt ) ) {
			$list_col_cnt = 1;
		}
		$view                = 'grid';
		$atts['col_cnt']     = (int) $list_col_cnt;
		$atts['col_cnt_min'] = 1;
		unset( $atts['col_cnt_xl'], $atts['col_cnt_tablet'], $atts['col_cnt_mobile'] );
	}
}

$builder_post = false;
if ( $builder_id ) {
	$builder_post = get_post( (int) $builder_id );
}

if ( 'archive' != $shortcode_type && empty( $loadmore_type ) ) {
	$loadmore_type = 'no';
}

$posts         = array();
$is_filter_cat = false;
$props         = array(
	'widget'         => true,
	'posts_layout'   => $view,
	'cpt'            => false !== strpos( $post_type, ALPHA_NAME ) ? substr( $post_type, strlen( ALPHA_NAME ) + 1 ) : $post_type,
	'thumbnail_size' => $thumbnail_size,
);

// Filter by Category ////////////////////////////////////////////////////////////////////////
if ( 'yes' == $filter_cat && 'archive' == $shortcode_type && ! $filter_cat_tax && 'product' == $post_type ) {
	$filter_cat_tax = 'product_cat';
}

if ( empty( $source ) && 'yes' == $filter_cat && $filter_cat_tax ) {
	$term_args = array(
		'taxonomy' => sanitize_text_field( $filter_cat_tax ),
	);

	if ( $post_tax == $filter_cat_tax && ! empty( $post_terms ) ) {
		if ( ! is_array( $post_terms ) ) {
			$post_terms = array_map( 'absint', explode( ',', $post_terms ) );
		}
		if ( 1 < count( $post_terms ) ) {
			$term_args['include'] = $post_terms;
			$term_args['orderby'] = 'include';
		} else {
			$term_args['parent'] = count( $post_terms ) ? $post_terms[0] : 0;
		}
	}

	$filter_terms = get_terms( $term_args );

	if ( is_array( $filter_terms ) && count( $filter_terms ) > 1 ) {
		$slugs         = array();
		$category_html = '';
		$idx           = 0;
		$active_cat    = '';
		if ( ! empty( $atts['cats'] ) ) {
			$active_cat = sanitize_text_field( $atts['cats'] );
		} elseif ( ! empty( $_REQUEST['product_cat'] ) ) {
			$active_cat = sanitize_text_field( $_REQUEST['product_cat'] );
		} elseif ( is_archive() ) {
			$current_term = get_queried_object();
			if ( $current_term && isset( $current_term->slug ) ) {
				$active_cat = $current_term->slug;
			}
		}

		foreach ( $filter_terms as $term_cat ) {
			$id             = $term_cat->term_id;
			$name           = $term_cat->name;
			$slug           = $term_cat->slug;
			$slugs[]        = $slug;
			$category_html .= '<li><a href="' . esc_url( get_term_link( $term_cat ) ) . '" class="nav-filter' . ( ( 0 == $idx && 'yes' != $show_all_filter && ! $active_cat ) || ( $active_cat == $slug ) ? ' active' : '' ) . '" data-cat="' . esc_attr( $slug ) . '">' . esc_html( $name ) . '</a></li>';
			++ $idx;
		}

		if ( $category_html ) {
			$all_link = get_post_type_archive_link( $post_type );
			if ( ! $all_link && $post_type ) {
				$all_link = site_url() . '?post_type=' . $post_type;
			}
			$category_html = '<ul class="nav-filters post-filters">' . ( 'yes' == $show_all_filter ? '<li class="nav-filter-clean"><a href="' . esc_url( $all_link ) . '" class="nav-filter' . ( ! $active_cat ? ' active' : '' ) . '" data-cat="*">' . esc_html__( 'All', 'alpha-core' ) . '</a></li>' : '' ) . $category_html . '</ul>';

			$props['filter_cat'] = true;
			$is_filter_cat       = true;
		}
	}
}

if ( empty( $shortcode_type ) ) {
	if ( 'terms' == $source ) { // terms
		if ( $tax ) {
			$args = array(
				'taxonomy'   => sanitize_text_field( $tax ),
				'hide_empty' => false,
			);
			if ( $count || '0' == $count ) {
				$args['number'] = (int) $count;
			}
			if ( $orderby_term ) {
				$args['orderby'] = sanitize_text_field( $orderby_term );
			}
			if ( $orderway ) {
				$args['order'] = sanitize_text_field( $orderway );
			}
			if ( ! empty( $terms ) ) {
				if ( ! is_array( $terms ) ) {
					$terms = explode( ',', $terms );
				}
				$args['orderby'] = 'include';
				$args['include'] = array_map( 'absint', $terms );
			}
			$posts = get_terms( $args );
		}
	} elseif ( empty( $source ) ) { // posts
		$args = array(
			'post_status' => 'publish',
		);
		if ( $post_type ) {
			$args['post_type'] = sanitize_text_field( $post_type );
		}

		if ( is_front_page() ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = get_query_var( 'paged' );
		}
		if ( $paged ) {
			$args['paged'] = (int) $paged;
		}

		if ( $count || '0' == $count ) {
			$args['posts_per_page'] = (int) $count;
		}

		if ( ! $post_tax ) {
			$post_terms = '';
		}

		// query args to filter by category
		if ( $filter_cat_tax && ! empty( $atts['cats'] ) ) {
			$filter_cat_terms = $atts['cats'];
			if ( ! is_array( $filter_cat_terms ) ) {
				$filter_cat_terms = explode( ',', $filter_cat_terms );
			}
			$args['tax_query'] = array(
				array(
					'taxonomy' => sanitize_text_field( $filter_cat_tax ),
					'field'    => is_numeric( $filter_cat_terms[0] ) ? 'term_id' : 'slug',
					'terms'    => array_map( 'sanitize_text_field', $filter_cat_terms ),
				),
			);
		}

		if ( ! empty( $post_terms ) ) {
			if ( ! is_array( $post_terms ) ) {
				$post_terms = explode( ',', $post_terms );
			}
			$tax_name = $post_tax;
			if ( $tax_name ) {
				if ( ! isset( $args['tax_query'] ) ) {
					$args['tax_query'] = array();
				}
				$args['tax_query'][] = array(
					'taxonomy' => sanitize_text_field( $tax_name ),
					'field'    => is_numeric( $post_terms[0] ) ? 'term_id' : 'slug',
					'terms'    => array_map( 'sanitize_text_field', $post_terms ),
				);
			}
		}
		if ( $orderby ) {
			$args['orderby'] = sanitize_text_field( $orderby );
		}
		if ( $orderway ) {
			$args['order'] = sanitize_text_field( $orderway );
		}

		if ( $is_related ) {
			$args['post__not_in']  = array( $is_related );
			$args['category__in']  = wp_get_post_categories( $is_related );
			$args['no_found_rows'] = true;
		}
		// show first filter
		if ( 'yes' != $show_all_filter && ! empty( $filter_terms ) ) {
			foreach ( $filter_terms as $term_cat ) {
				$args['category'] = $term_cat->term_taxonomy_id;
				break;
			}
		}
		$posts_query = new WP_Query( $args );
	}
} elseif ( 'archive' == $shortcode_type ) { // shop builder
	global $wp_query;
	$posts_query = $wp_query;
}
if ( isset( $posts_query ) && ! $posts_query->have_posts() && ! empty( $post_found_nothing ) && 'archive' == $shortcode_type ) {
	echo '<div class="nothing-found-message">' . alpha_strip_script_tags( $post_found_nothing ) . '</div>';
	return;
}
if ( ( ( empty( $source ) && $posts_query->have_posts() ) || ! empty( $category_html ) ) || ( 'terms' == $source && ! empty( $posts ) ) ) {
	// enqueue style
	if ( empty( $source ) && $is_filter_cat ) {
		wp_enqueue_style( 'alpha-tab', alpha_core_framework_uri( '/widgets/tab/tab' . ( is_rtl() ? '-rtl' : '' ) . '.min.css' ), array(), ALPHA_CORE_VERSION );
	}

	$wrapper_id      = 'alpha-posts-grid-' . rand( 1000, 9999 );
	$wrap_class      = 'alpha-posts-grid';
	$container_class = 'alpha-posts-grid-container';
	$container_attrs = '';

	$col_cnt          = alpha_elementor_grid_col_cnt( $atts );
	$props['col_cnt'] = $col_cnt;
	$grid_space_class = alpha_get_grid_space_class( $atts );
	if ( $grid_space_class ) {
		$container_class .= $grid_space_class;
	}

	if ( 'archive' == $shortcode_type ) { // shop builder
		if ( 'product' == $post_type ) {
			$wrap_class .= ' archive-products';
			if ( ! $builder_post ) {
				$container_class .= ' shop-default';
			}
		} else {
			$wrap_class .= ' archive-posts';
		}
	}

	if ( $posts_wrap_cls ) {
		$container_class .= ' ' . trim( $posts_wrap_cls );
	}

	echo '<div id="' . esc_attr( $wrapper_id ) . '" class="' . esc_attr( $wrap_class ) . '">';

	if ( $builder_post ) {
		$css  = get_post_meta( $builder_id, ALPHA_NAME . '_blocks_style_options_css', true );
		$css .= get_post_meta( $builder_id, '_' . ALPHA_NAME . '_builder_css', true );
		$css .= get_post_meta( $builder_id, 'page_css', true );
		if ( $css ) {
			if ( alpha_is_elementor_preview() ) {
				echo '<style scope="scope">';
				echo wp_strip_all_tags( $css );
				echo '</style>';
			} else {
				wp_add_inline_style( 'alpha-style', '/* Post Type Builder CSS */' . PHP_EOL . wp_strip_all_tags( $css ) );
			}
		}

		$page_js = get_post_meta( $builder_id, 'page_js', true );
		if ( $page_js ) {
			if ( alpha_is_elementor_preview() ) {
				echo '<script>';
				echo alpha_strip_script_tags( $page_js );
				echo '</script>';
			} else {
				wp_add_inline_script( 'alpha-theme', '/* Post Type Builder JS */' . PHP_EOL . alpha_strip_script_tags( $page_js ) );
			}
		}
	}

	// view
	if ( 'creative' == $view ) {
		$post_count = 0;

		$container_class .= ' creative-grid row';
		if ( function_exists( 'alpha_is_elementor_preview' ) && alpha_is_elementor_preview() ) {
			$container_class .= ' editor-mode';
		}
		if ( isset( $atts['creative_mode'] ) ) {
			$container_class       .= 'preset-grid grid-layout-' . $atts['creative_mode'];
			$props['creative_mode'] = $atts['creative_mode'];
		}

		if ( is_array( $items_list ) ) {
			$props['repeaters'] = array(
				'ids'    => array(),
				'images' => array(),
			);
			foreach ( $items_list as $item ) {
				if ( ! isset( $props['repeaters']['ids'][ (int) $item['item_no'] ] ) ) {
					$props['repeaters']['ids'][ (int) $item['item_no'] ] = '';
				}
				$props['repeaters']['ids'][ (int) $item['item_no'] ]   .= ' elementor-repeater-item-' . $item['_id'];
				$props['repeaters']['images'][ (int) $item['item_no'] ] = $item['item_thumb_size'];
			}
		}
	} elseif ( 'slider' == $view ) {
		$container_class .= ' ' . alpha_get_slider_class( $atts );
		$container_attrs .= ' data-slider-options="' . esc_attr(
			json_encode(
				alpha_get_slider_attrs( $atts, $col_cnt )
			)
		) . '"';
	} elseif ( 'masonry' == $view ) {
		wp_enqueue_script( 'isotope-pkgd' );

		$container_class .= ' grid masonry';
		$container_attrs .= " data-creative-breaks='" . json_encode(
			array(
				'md' => alpha_get_breakpoints( 'md' ),
				'lg' => alpha_get_breakpoints( 'lg' ),
			)
		) . "'";
		$container_attrs .= ' data-grid-options="' . esc_attr(
			json_encode(
				array(
					'itemSelector' => '.alpha-tb-item',
					'layoutMode'   => 'masonry',
					'isOriginLeft' => ! is_rtl() ? true : false,
				)
			)
		) . '"';
	}

	if ( $thumbnail_size ) {
		$GLOBALS['alpha_post_image_size'] = $thumbnail_size;
	}

	if ( ! empty( $category_html ) ) {
		echo apply_filters( 'alpha_products_filter_cat_html', $category_html );
	}

	// Load More Properties
	if ( empty( $source ) ) {
		$atts['shortcode']       = 'alpha-posts-grid';
		$props['loadmore_props'] = shortcode_atts(
			$default_atts,
			$atts
		);
		if ( isset( $args ) ) {
			$props['loadmore_args'] = $args;
		}
		$props['posts']          = $posts_query;
		$props['loadmore_type']  = $loadmore_type;
		$props['loadmore_label'] = $loadmore_label;
		$props['is_filter_cat']  = $is_filter_cat;
	}


	$props['wrapper_class'] = explode( ' ', $container_class );
	$props['wrapper_attrs'] = $container_attrs;

	// Tooltip to edit
	$edit_link = '';
	if ( $builder_post && current_user_can( 'edit_pages' ) && ! is_customize_preview() &&
		( ! function_exists( 'alpha_is_elementor_preview' ) || ! alpha_is_elementor_preview() ) &&
		( ! function_exists( 'alpha_is_wpb_preview' ) || ! alpha_is_wpb_preview() ) &&
		apply_filters( 'alpha_show_templates_edit_link', true ) ) {
		$edit_link    = admin_url( 'post.php?post=' . absint( $builder_id ) . '&action=edit' );
		$builder_type = get_post_meta( $builder_id, ALPHA_NAME . '_template_type', true );
		if ( ! $builder_type ) {
			$builder_type = esc_html__( 'Template', 'alpha-core' );
		}
	}

	/**
	 * Fires before archive posts widget render.
	 *
	 * @since 1.0
	 */
	do_action( 'alpha_before_posts_loop', $props );

	alpha_get_template_part( 'posts/post', 'loop-start' );

	$original_query          = $GLOBALS['wp_query'];
	$original_queried_object = $GLOBALS['wp_query']->queried_object;
	if ( empty( $source ) ) { // posts

		$original_post = $GLOBALS['post'];
		if ( 'product' == $post_type && ! class_exists( 'WooCommerce' ) ) {
			$post_type = 'post';
		}

		if ( 'product' == $post_type ) {
			if ( function_exists( 'alpha_get_option' ) && alpha_get_option( 'compare_available' ) ) {
				wp_enqueue_style( 'alpha-product-compare', alpha_core_framework_uri( '/addons/product-compare/product-compare' . ( is_rtl() ? '-rtl' : '' ) . '.min.css' ), array(), ALPHA_VERSION );
				wp_enqueue_script( 'alpha-product-compare', alpha_core_framework_uri( '/addons/product-compare/product-compare' . ALPHA_JS_SUFFIX ), array( 'alpha-framework-async' ), ALPHA_VERSION, true );
			}
			if ( function_exists( 'alpha_quickview_add_scripts' ) ) {
				alpha_quickview_add_scripts();
				wp_enqueue_style( 'alpha-share', alpha_core_framework_uri( '/widgets/share/share' . ( is_rtl() ? '-rtl' : '' ) . '.min.css' ), array(), ALPHA_CORE_VERSION );
			}
			wp_enqueue_style( 'alpha-product', alpha_core_framework_uri( '/widgets/products/product' . ( is_rtl() ? '-rtl' : '' ) . '.min.css' ), array(), ALPHA_CORE_VERSION );
			if ( defined( 'ALPHA_VERSION' ) ) {
				wp_enqueue_style( 'alpha-theme-single-product', ALPHA_ASSETS . '/css/pages/single-product' . ( is_rtl() ? '-rtl' : '' ) . '.min.css', array(), ALPHA_VERSION );
			}
			wp_enqueue_script( 'alpha-woocommerce' );

			if ( isset( $GLOBALS['product'] ) ) {
				$original_product = $GLOBALS['product'];
			}

			$GLOBALS['alpha_tb_catalog_mode'] = false;
			if ( function_exists( 'alpha_get_option' ) && alpha_get_option( 'catalog_mode' ) ) {
				$GLOBALS['alpha_tb_catalog_mode'] = true;
			}

			if ( ! $builder_post ) {
				wc_set_loop_prop( 'alpha_print_content_only', true );
			}
			if ( $thumbnail_size ) {
				wc_set_loop_prop( 'thumbnail_size', $thumbnail_size );
			}

			// display product categories
			if ( 'archive' == $shortcode_type ) {
				$show_info      = alpha_wc_category_show_info();
				$category_class = array( alpha_get_category_classes() );
				wc_set_loop_prop( 'show_link', 'yes' == $show_info['link'] );
				wc_set_loop_prop( 'show_count', 'yes' == $show_info['count'] );
				wc_set_loop_prop( 'category_class', $category_class );
				$categories_html = woocommerce_maybe_show_product_subcategories();
				if ( $categories_html ) {
					wp_enqueue_style( 'alpha-product-category', alpha_core_framework_uri( '/widgets/categories/category' . ( is_rtl() ? '-rtl' : '' ) . '.min.css' ), array(), ALPHA_CORE_VERSION );
					echo apply_filters( 'alpha_posts_grid_product_subcategories_html', str_replace( array( '<li class="category-wrap', '</li>' ), array( '<div class="category-wrap', '</div>' ), $categories_html ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				}

				global $wp_query;
				$posts_query = $wp_query;
			}
		} else {
			wp_enqueue_style( 'alpha-post', alpha_core_framework_uri( '/widgets/posts/post' . ( is_rtl() ? '-rtl' : '' ) . '.min.css' ), array(), ALPHA_CORE_VERSION );
		}

		while ( $posts_query->have_posts() ) {
			$posts_query->the_post();
			global $post;
			$GLOBALS['wp_query']->queried_object = $post;

			$item_cls = 'alpha-tb-item';

			$item_attrs = '';

			if ( $post_type ) {
				$item_cls .= ' ' . $post_type;
			}

			if ( 'product' == $post_type ) {
				$GLOBALS['product'] = wc_get_product( $post->ID );
				if ( ! $GLOBALS['product'] || ! $GLOBALS['product']->is_visible() ) {
					continue;
				}
				$item_cls .= ' product-wrap';

				// add product attributes to be used in add to cart popup
				$item_attrs .= ' data-title="' . esc_attr( get_the_title() ) . '" data-link="' . esc_url( get_permalink() ) . '"';
			}

			if ( 'creative' == $view && isset( $post_count ) ) {
				$post_count++;
				$repeaters = alpha_get_loop_prop( 'repeaters' );
				$item_cls .= ' grid-item';
				if ( ! empty( $repeaters ) ) {
					if ( isset( $repeaters['ids'][ $post_count ] ) ) {
						$item_cls .= $repeaters['ids'][ $post_count ];
					}
					if ( isset( $repeaters['ids'][0] ) ) {
						$item_cls .= $repeaters['ids'][0];
					}
					if ( isset( $repeaters['images'][ $post_count ] ) ) {
						$GLOBALS['alpha_post_image_size'] = $repeaters['images'][ $post_count ];
					}
				}
				$item_attrs = ' data-grid-idx="' . (int) $post_count . '"';
			}

			if ( $edit_link && $builder_post ) {
				/* translators: template name */
				echo '<div class="alpha-edit-link d-none" data-title="' . sprintf( esc_html__( 'Edit %1$s: %2$s', 'alpha-core' ), esc_attr( str_replace( '_', ' ', $builder_type ) ), esc_attr( get_the_title( $builder_id ) ) ) . '" data-link="' . esc_url( $edit_link ) . '"></div>';
				$item_cls .= ' alpha-block';
				$edit_link = '';
			}

			echo '<div ';
			if ( ! $builder_post && 'product' == $post_type ) {
				echo 'class="' . esc_attr( $item_cls ) . '"';
			} else {
				post_class( $item_cls );
			}
			echo '' . $item_attrs . '>';

			/**
			 * Fires before rendering post loop item.
			 *
			 * @since 1.0
			 */
			do_action( 'alpha_post_loop_before_item' );
			if ( $builder_post ) {
				echo do_blocks( $builder_post->post_content );
			} else {
				if ( 'product' == $post_type ) {
					wc_get_template_part( 'content', 'product' );
				} elseif ( 'post' == $post_type || false !== strpos( $post_type, ALPHA_NAME ) ) {
					alpha_get_template_part( 'posts/post', '', array( 'shortcode_type' => $shortcode_type ) );
				} else {
					alpha_get_template_part( 'posts/type/post', 'default' );
				}
			}

			/**
			 * Fires after rendering post loop item.
			 *
			 * @since 1.0
			 */
			do_action( 'alpha_post_loop_after_item' );

			do_action( 'alpha_posts_grid_item_rendered', $builder_post, $atts );
			echo '</div>';
		}

		wp_reset_postdata();

		// Restore global data.
		$GLOBALS['post'] = $original_post; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
		if ( 'product' == $post_type ) {
			if ( isset( $original_product ) ) {
				$GLOBALS['product'] = $original_product; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
			}
		}
	} elseif ( 'terms' == $source ) { // terms
		global $alpha_page_layout;
		$alpha_page_layout = alpha_get_page_layout();

		$original_is_tax     = $GLOBALS['wp_query']->is_tax;
		$original_is_archive = $GLOBALS['wp_query']->is_archive;

		$GLOBALS['wp_query']->is_tax     = true;
		$GLOBALS['wp_query']->is_archive = true;

		if ( ! $builder_post ) {
			wp_enqueue_style( 'alpha-product-category', alpha_core_framework_uri( '/widgets/categories/category' . ( is_rtl() ? '-rtl' : '' ) . '.min.css' ), array(), ALPHA_CORE_VERSION );
			if ( 'product_cat' == $tax ) {
				if ( class_exists( 'WooCommerce' ) ) {
					$show_info      = alpha_wc_category_show_info();
					$category_class = array( alpha_get_category_classes() );
					wc_set_loop_prop( 'show_link', 'yes' == $show_info['link'] );
					wc_set_loop_prop( 'show_count', 'yes' == $show_info['count'] );
					wc_set_loop_prop( 'category_class', $category_class );
				} else {
					$tax = '';
				}
			}
		}

		foreach ( $posts as $term ) {
			$GLOBALS['wp_query']->queried_object = $term;

			$item_cls   = 'alpha-tb-item';
			$item_attrs = '';
			if ( 'creative' == $view && isset( $post_count ) ) {
				$post_count++;
				$repeaters = alpha_get_loop_prop( 'repeaters' );
				$item_cls .= ' grid-item';
				if ( ! empty( $repeaters ) ) {
					if ( isset( $repeaters['ids'][ $post_count ] ) ) {
						$item_cls .= $repeaters['ids'][ $post_count ];
					}
					if ( isset( $repeaters['ids'][0] ) ) {
						$item_cls .= $repeaters['ids'][0];
					}
					if ( isset( $repeaters['images'][ $post_count ] ) ) {
						$GLOBALS['alpha_post_image_size'] = $repeaters['images'][ $post_count ];
					}
				}
				$item_attrs = ' data-grid-idx="' . (int) $post_count . '"';
			}

			if ( $edit_link && $builder_post ) {
				/* translators: template name */
				echo '<div class="alpha-edit-link d-none" data-title="' . sprintf( esc_html__( 'Edit %1$s: %2$s', 'alpha-core' ), esc_attr( str_replace( '_', ' ', $builder_type ) ), esc_attr( get_the_title( $builder_id ) ) ) . '" data-link="' . esc_url( $edit_link ) . '"></div>';
				$item_cls .= ' alpha-block';
				$edit_link = '';
			}

			echo '<div class="' . esc_attr( $item_cls ) . '"' . $item_attrs . '>';

			/**
			 * Fires before rendering post loop item.
			 *
			 * @since 1.0
			 */
			do_action( 'alpha_post_loop_before_item' );

			if ( $builder_post ) {
				echo do_blocks( $builder_post->post_content );
			} elseif ( 'product_cat' == $tax ) {
				$category = $term;

				wc_get_template(
					'content-product-cat.php',
					array(
						'category' => $category,
						'html_tag' => 'div',
					)
				);
			} else {
				alpha_get_template_part( 'posts/type/category', 'default' );
			}

			/**
			 * Fires after rendering post loop item.
			 *
			 * @since 1.0
			 */
			do_action( 'alpha_post_loop_after_item' );

			do_action( 'alpha_posts_grid_item_rendered', $builder_post, $atts );
			echo '</div>';
		}

		$GLOBALS['wp_query']                 = $original_query; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
		$GLOBALS['wp_query']->queried_object = $original_queried_object; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
		$GLOBALS['wp_query']->is_tax         = $original_is_tax; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
		$GLOBALS['wp_query']->is_archive     = $original_is_archive; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited

		$alpha_page_layout = '';
		unset( $GLOBALS['alpha_page_layout'] );
	}
	$GLOBALS['wp_query']                 = $original_query; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
	$GLOBALS['wp_query']->queried_object = $original_queried_object; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited

	unset( $GLOBALS['alpha_post_image_size'], $GLOBALS['woocommerce_loop'] );

	// set posts layout to grid to display pagination
	if ( 'creative' == $view || 'masonry' == $view ) {
		alpha_set_loop_prop( 'posts_layout', 'grid' );
	}
	alpha_get_template_part( 'posts/post', 'loop-end' );

	/**
	 * Fires after archive posts widget render.
	 *
	 * @since 1.0
	 */
	do_action( 'alpha_after_posts_loop' );

	echo '</div>';
}
