<?php

/**
 * Alpha Heading Widget Extend
 *
 * Alpha Widget to display heading.
 *
 * @author     Andon
 * @package    WP Alpha Core FrameWork
 * @subpackage Core
 * @since      1.0
 */

use Elementor\Controls_Manager;
use Elementor\Alpha_Controls_Manager;
add_action(
	'elementor/element/' . ALPHA_NAME . '_widget_heading' . '/section_heading_title/after_section_end',
	function( $self, $args ) {
		$self->update_control(
			'decoration',
			array(
				'type'    => Alpha_Controls_Manager::IMAGE_CHOOSE,
				'options' => array(
					''                           => 'assets/images/heading/heading-1.jpg',
					'cross'                      => 'assets/images/heading/heading-2.jpg',
					'underline'                  => 'assets/images/heading/heading-3.jpg',
					'underline title-underline2' => 'assets/images/heading/heading-4.jpg',
				),
				'width'   => 2,
			)
		);

		$self->add_control(
			'underline_height',
			array(
				'label'      => esc_html__( 'Underline Height', 'alpha-core' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array(
					'px',
					'%',
				),
				'range'      => array(
					'px' => array(
						'step' => 1,
						'min'  => 1,
						'max'  => 10,
					),
					'%'  => array(
						'step' => 1,
						'min'  => 0,
						'max'  => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .title:after'           => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .title-underline:after' => 'height: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'decoration' => array( 'underline', 'underline title-underline2' ),
				),
			),
			array(
				'position' => array(
					'of' => 'decoration',
				),
			)
		);

		$self->add_control(
			'underline_width',
			array(
				'label'      => esc_html__( 'Underline Width', 'alpha-core' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array(
					'px',
					'%',
				),
				'range'      => array(
					'px' => array(
						'step' => 1,
						'min'  => 1,
						'max'  => 100,
					),
					'%'  => array(
						'step' => 1,
						'min'  => 0,
						'max'  => 100,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .title:after' => 'width: {{SIZE}}{{UNIT}};',
				),
				'condition'  => array(
					'decoration' => 'underline title-underline2',
				),
			),
			array(
				'position' => array(
					'of' => 'decoration',
				),
			)
		);
	},
	10,
	2
);

add_action(
	'elementor/element/' . ALPHA_NAME . '_widget_heading' . '/section_heading_title_style/after_section_end',
	function( $self, $args ) {
		$self->update_control(
			'title_spacing',
			array(
				'selectors' => array(
					'{{WRAPPER}} .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);
	},
	10,
	2
);
