/**
 * Alpha Elementor Admin Extend
 * 
 * @package Alpha Core FrameWork
 * @since 4.0
 */

'use strict';

var themeElementorAdmin = window.themeElementorAdmin || {};

( function ( $ ) {
    themeElementorAdmin.activeSection = null;
    themeElementorAdmin.editedElement = null;

    themeElementorAdmin.init = function () {
        var self = this;

        this.initSideHeaderPreview();

        elementor.channels.editor.on( 'section:activated', self.initFlipboxSectionActivated );

        window.elementor.on( 'preview:loaded', function () {
            elementor.$preview[ 0 ].contentWindow.themeElementorAdmin = themeElementorAdmin;
        } );
    }

    // Init flipbox section activated event
    themeElementorAdmin.initFlipboxSectionActivated = function ( sectionName, editor ) {

        var editedElement = editor.getOption( 'editedElementView' ),
            prevEditedElement = editedElement;

        if ( prevEditedElement
            && 'udesign_widget_flipbox' === prevEditedElement.model.get( 'widgetType' )
            && 'udesign_widget_flipbox' !== editedElement.model.get( 'widgetType' )
        ) {

            prevEditedElement.$el.find( '.flipbox' ).removeClass( 'hover' );

            self.editedElement = null;
        }

        if ( 'udesign_widget_flipbox' !== editedElement.model.get( 'widgetType' ) ) {
            return;
        }

        themeElementorAdmin.editedElement = editedElement;
        themeElementorAdmin.activeSection = sectionName;

        var isBackSide = -1 !== [ 'section_back_side_content' ].indexOf( sectionName );

        if ( isBackSide ) {
            editedElement.$el.find( '.flipbox' ).addClass( 'flipped' );
        } else {
            editedElement.$el.find( '.flipbox' ).removeClass( 'flipped' );
        }
    }

    themeElementorAdmin.initSideHeaderPreview = function () {
        $( document )
            .on( 'change', '.elementor-control-alpha_header_pos select', function ( e ) {
                var iframejQuery = document.getElementById( 'elementor-preview-iframe' ).contentWindow.jQuery;
                if ( $( this ).val() ) {
                    iframejQuery( 'body' ).addClass( 'side-header' );
                    if ( !iframejQuery( '.custom-header' ).parent().hasClass( 'header-area' ) ) {
                        iframejQuery( '.custom-header' ).wrap( '<div class="header-area"></div>' );
                    }
                } else {
                    iframejQuery( 'body' ).removeClass( 'side-header' );
                    if ( iframejQuery( '.custom-header' ).parent().hasClass( 'header-area' ) ) {
                        iframejQuery( '.custom-header' ).unwrap( '.header-area' );
                    }
                }
            } )
            .on( 'change', '.elementor-control-alpha_side_header_breakpoint select', function ( e ) {
                var iframejQuery = document.getElementById( 'elementor-preview-iframe' ).contentWindow.jQuery;
                iframejQuery( 'body' ).removeClass( 'side-on-desktop side-on-tablet side-on-mobile' );
                if ( $( this ).val() ) {
                    iframejQuery( 'body' ).addClass( 'side-on-' + $( this ).val() );
                }
            } )
    }

    $( window ).on( 'elementor:init', function () {
        themeElementorAdmin.init();
    } );
} )( jQuery );
