<?php
/**
 * Alpha Elementor Single Product Linked Products Widget
 *
 * @author     Andon
 * @package    Alpha Core Framework
 * @subpackage Core
 * @since      4.1
 */
defined( 'ABSPATH' ) || die;

use Elementor\Controls_Manager;

class Alpha_Product_Linked_Products_Elementor_Widget extends Alpha_Products_Elementor_Widget {

	public function get_name() {
		return ALPHA_NAME . '_sproduct_linked_products';
	}

	public function get_title() {
		return esc_html__( 'Linked Products', 'alpha-core' );
	}

	public function get_icon() {
		return 'alpha-elementor-widget-icon eicon-product-related';
	}

	public function get_categories() {
		return array( 'alpha_single_product_widget', 'alpha_cart_widget' );
	}

	public function get_keywords() {
		return array( 'single', 'custom', 'layout', 'product', 'woocommerce', 'shop', 'store', 'linked_products', 'cart', 'cross', 'upsell', 'related' );
	}

	public function get_script_depends() {
		$depends = array();
		if ( alpha_is_elementor_preview() ) {
			$depends[] = 'alpha-elementor-js';
		}
		return $depends;
	}

	protected function register_controls() {
		parent::register_controls();

		$this->remove_control( 'ids' );
		$this->remove_control( 'categories' );

		global $post;
		if ( ( $post && ( 'cart' == get_post_meta( $post->ID, ALPHA_NAME . '_template_type', true ) || is_cart() ) ) ) {
				$this->update_control(
					'status',
					array(
						'label'   => esc_html__( 'Product Status', 'alpha-core' ),
						'type'    => Controls_Manager::HIDDEN,
						'default' => 'crosssell',
						'options' => array(
							'crosssell' => esc_html__( 'Cross-sells Products', 'alpha-core' ),
						),
					)
				);
		} else {
			$this->update_control(
				'status',
				array(
					'label'   => esc_html__( 'Product Status', 'alpha-core' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'related',
					'options' => array(
						'related' => esc_html__( 'Related Products', 'alpha-core' ),
						'upsell'  => esc_html__( 'Upsells Products', 'alpha-core' ),
					),
				)
			);

		}
	}

	protected function render() {
		global $post;
		if ( ( $post && ( is_cart() || 'cart' == get_post_meta( $post->ID, ALPHA_NAME . '_template_type', true ) ) ) ) {
			parent::render();
		} elseif ( alpha_is_product() || ( $post && 'product_layout' == get_post_meta( $post->ID, ALPHA_NAME . '_template_type', true ) ) ) {
			if ( apply_filters( 'alpha_single_product_builder_set_preview', false ) ) {
				parent::render();
				do_action( 'alpha_single_product_builder_unset_preview' );
			}
		}
	}
}
