<?php
/**
 * Alpha Template
 *
 * @author     Andon
 * @package    Alpha Core
 * @subpackage Core
 * @since      4.0
 */

defined( 'ABSPATH' ) || die;

use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Color;

if ( ! class_exists( 'Alpha_Builders_Extend' ) ) {
	class Alpha_Builders_Extend {

		/**
		 * The Constructor
		 *
		 * @since 4.0
		 */
		public function __construct() {

			// Builder Extends
			require_once ALPHA_CORE_INC . '/builders/header/class-alpha-header-builder-extend.php';

			if ( class_exists( 'WooCommerce' ) ) {
				require_once ALPHA_CORE_INC . '/builders/shop/class-alpha-shop-builder-extend.php';
			}
			// Should be called after framework class exists
			add_action( 'alpha_after_core_framework_builders', array( $this, 'after_framework_builders_init' ) );

			add_action( 'elementor/element/udesign_sproduct_image/section_product_gallery_content/before_section_end', array( $this, 'update_sproduct_image_controls' ), 10, 2 );
		}

		public function after_framework_builders_init() {
			if ( class_exists( 'WooCommerce' ) ) {
				require_once ALPHA_CORE_INC . '/builders/single-product/class-alpha-single-product-builder-extend.php';
			}
		}

		public function update_sproduct_image_controls( $self, $args ) {
			$self->update_control(
				'sp_type',
				array(
					'label'   => esc_html__( 'Type', 'alpha-core' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '',
					'options' => array(
						'horizontal' => esc_html__( 'Horizontal Thumbs', 'alpha-core' ),
						'vertical'   => esc_html__( 'Vertical Thumbs', 'alpha-core' ),
					),
				)
			);
		}
	}

	new Alpha_Builders_Extend;
}
