<?php
/**
 * Alpha IconList Widget Render
 *
 * @author     D-THEMES
 * @package    WP Alpha Core FrameWork
 * @subpackage Core
 * @since      1.0
 */

defined( 'ABSPATH' ) || die;

use Elementor\Icons_Manager;

extract( // @codingStandardsIgnoreLine
	shortcode_atts(
		array(
			'view'      => 'block',
			'title'     => '',
			'class'     => '',
			'icon_list' => '',
		),
		$atts
	)
);

$html = '<div class="alpha-icon-lists ' . $view . '-type">';

if ( $title ) {
	$html .= '<h4 class="list-title">' . alpha_strip_script_tags( $title ) . '</h4>';
}

if ( is_array( $icon_list ) ) {
	foreach ( $icon_list as $icon_item ) {
		$link            = $icon_item['link'];
		$attrs           = [];
		$attrs['href']   = ! empty( $link['url'] ) ? esc_url( $link['url'] ) : 'https://your-link.com';
		$attrs['target'] = ! empty( $link['is_external'] ) ? '_blank' : '';
		$attrs['rel']    = ! empty( $link['nofollow'] ) ? 'nofollow' : '';
		if ( ! empty( $link['custom_attributes'] ) ) {
			foreach ( explode( ',', $link['custom_attributes'] ) as $attr ) {
				$key   = explode( '|', $attr )[0];
				$value = implode( ' ', array_slice( explode( '|', $attr ), 1 ) );
				if ( isset( $attrs[ $key ] ) ) {
					$attrs[ $key ] .= ' ' . $value;
				} else {
					$attrs[ $key ] = $value;
				}
			}
		}
		$link_attrs = '';
		foreach ( $attrs as $key => $value ) {
			if ( ! empty( $value ) ) {
				$link_attrs .= $key . '="' . esc_attr( $value ) . '" ';
			}
		}
		$html .= '<a class="alpha-icon-list-item" ' . $link_attrs . '>';
		if ( ! empty( $icon_item['selected_icon']['value'] ) ) {
			if ( 'svg' == $icon_item['selected_icon']['library'] ) {
				ob_start();
				Icons_Manager::render_icon( $icon_item['selected_icon'], [ 'aria-hidden' => 'true' ] );
				$icon = ob_get_clean();
			} else {
				$icon = '<i class="' . esc_attr( $icon_item['selected_icon']['value'] ) . '"></i>';
			}
			$html .= $icon;
		}
		$html .= alpha_strip_script_tags( $icon_item['text'] ) . '</a>';
	}
}

$html .= '</div>';

echo do_shortcode( $html );
