<?php
if ( ! empty( $settings['bg'] ) || ! empty( $settings['border'] ) || ! empty( $settings['padding'] ) || ! empty( $settings['margin'] ) || ! empty( $settings['position'] ) || ! empty( $settings['borderRadius'] ) || ! empty( $settings['hideXl'] ) || ! empty( $settings['hideLg'] ) || ! empty( $settings['hideMd'] ) || ! empty( $settings['hideSm'] ) ) {
	echo 'html ' . sanitize_text_field( $settings['selector'] ) . '{';
	if ( ! empty( $settings['bg'] ) ) {
		if ( ! empty( $settings['bg']['color'] ) ) {
			echo 'background-color:' . sanitize_text_field( $settings['bg']['color'] ) . ';';
		}
		if ( ! empty( $settings['bg']['img_url'] ) ) {
			echo 'background-image:url(' . esc_url( $settings['bg']['img_url'] ) . ');';
		}
		if ( ! empty( $settings['bg']['position'] ) ) {
			echo 'background-position:' . sanitize_text_field( $settings['bg']['position'] ) . ';';
		}
		if ( ! empty( $settings['bg']['attachment'] ) ) {
			echo 'background-attachment:' . sanitize_text_field( $settings['bg']['attachment'] ) . ';';
		}
		if ( ! empty( $settings['bg']['repeat'] ) ) {
			echo 'background-repeat:' . sanitize_text_field( $settings['bg']['repeat'] ) . ';';
		}
		if ( ! empty( $settings['bg']['size'] ) ) {
			echo 'background-size:' . sanitize_text_field( $settings['bg']['size'] ) . ';';
		}
	}

	if ( ! empty( $settings['border'] ) ) {
		if ( ! empty( $settings['border']['style'] ) ) {
			echo 'border-style:' . sanitize_text_field( $settings['border']['style'] ) . ';';
		}
		if ( isset( $settings['border']['top'], $settings['border']['right'], $settings['border']['bottom'], $settings['border']['left'] ) && strlen( $settings['border']['top'] ) && strlen( $settings['border']['right'] ) && strlen( $settings['border']['bottom'] ) && strlen( $settings['border']['left'] ) ) {
			echo 'border-width:' . sanitize_text_field( $settings['border']['top'] . ' ' . $settings['border']['right'] . ' ' . $settings['border']['bottom'] . ' ' . $settings['border']['left'] ) . ';';
		} else {
			if ( isset( $settings['border']['top'] ) && strlen( $settings['border']['top'] ) ) {
				echo 'border-top-width:' . sanitize_text_field( $settings['border']['top'] ) . ';';
			}
			if ( isset( $settings['border']['right'] ) && strlen( $settings['border']['right'] ) ) {
				echo 'border-right-width:' . sanitize_text_field( $settings['border']['right'] ) . ';';
			}
			if ( isset( $settings['border']['bottom'] ) && strlen( $settings['border']['bottom'] ) ) {
				echo 'border-bottom-width:' . sanitize_text_field( $settings['border']['bottom'] ) . ';';
			}
			if ( isset( $settings['border']['left'] ) && strlen( $settings['border']['left'] ) ) {
				echo 'border-left-width:' . sanitize_text_field( $settings['border']['left'] ) . ';';
			}
		}
		if ( ! empty( $settings['border']['color'] ) ) {
			echo 'border-color:' . sanitize_text_field( $settings['border']['color'] ) . ';';
		}
	}

	if ( ! empty( $settings['borderRadius'] ) ) {
		if ( isset( $settings['borderRadius']['top'], $settings['borderRadius']['right'], $settings['borderRadius']['bottom'], $settings['borderRadius']['left'] ) && strlen( $settings['borderRadius']['top'] ) && strlen( $settings['borderRadius']['right'] ) && strlen( $settings['borderRadius']['bottom'] ) && strlen( $settings['borderRadius']['left'] ) ) {
			echo 'border-radius:' . sanitize_text_field( $settings['borderRadius']['top'] . ' ' . $settings['borderRadius']['right'] . ' ' . $settings['borderRadius']['bottom'] . ' ' . $settings['borderRadius']['left'] ) . ';';
		} else {
			if ( isset( $settings['borderRadius']['top'] ) && strlen( $settings['borderRadius']['top'] ) ) {
				echo 'border-top-left-radius:' . sanitize_text_field( $settings['borderRadius']['top'] ) . ';';
			}
			if ( isset( $settings['borderRadius']['right'] ) && strlen( $settings['borderRadius']['right'] ) ) {
				echo 'border-top-right-radius:' . sanitize_text_field( $settings['borderRadius']['right'] ) . ';';
			}
			if ( isset( $settings['borderRadius']['bottom'] ) && strlen( $settings['borderRadius']['bottom'] ) ) {
				echo 'border-bottom-right-radius:' . sanitize_text_field( $settings['borderRadius']['bottom'] ) . ';';
			}
			if ( isset( $settings['borderRadius']['left'] ) && strlen( $settings['borderRadius']['left'] ) ) {
				echo 'border-bottom-left-radius:' . sanitize_text_field( $settings['borderRadius']['left'] ) . ';';
			}
		}
	}

	if ( ! empty( $settings['margin'] ) ) {
		if ( ! empty( $settings['margin']['top'] ) && ! empty( $settings['margin']['right'] ) && ! empty( $settings['margin']['bottom'] ) && ! empty( $settings['margin']['left'] ) ) {
			echo 'margin:' . sanitize_text_field( $settings['margin']['top'] . ' ' . $settings['margin']['right'] . ' ' . $settings['margin']['bottom'] . ' ' . $settings['margin']['left'] ) . ';';
		} else {
			if ( ! empty( $settings['margin']['top'] ) ) {
				echo 'margin-top:' . sanitize_text_field( $settings['margin']['top'] ) . ';';
			}
			if ( ! empty( $settings['margin']['right'] ) ) {
				echo 'margin-right:' . sanitize_text_field( $settings['margin']['right'] ) . ';';
			}
			if ( ! empty( $settings['margin']['bottom'] ) ) {
				echo 'margin-bottom:' . sanitize_text_field( $settings['margin']['bottom'] ) . ';';
			}
			if ( ! empty( $settings['margin']['left'] ) ) {
				echo 'margin-left:' . sanitize_text_field( $settings['margin']['left'] ) . ';';
			}
		}
	}

	if ( ! empty( $settings['padding'] ) ) {
		if ( ! empty( $settings['padding']['top'] ) && ! empty( $settings['padding']['right'] ) && ! empty( $settings['padding']['bottom'] ) && ! empty( $settings['padding']['left'] ) ) {
			echo 'padding:' . sanitize_text_field( $settings['padding']['top'] . ' ' . $settings['padding']['right'] . ' ' . $settings['padding']['bottom'] . ' ' . $settings['padding']['left'] ) . ';';
		} else {
			if ( ! empty( $settings['padding']['top'] ) ) {
				echo 'padding-top:' . sanitize_text_field( $settings['padding']['top'] ) . ';';
			}
			if ( ! empty( $settings['padding']['right'] ) ) {
				echo 'padding-right:' . sanitize_text_field( $settings['padding']['right'] ) . ';';
			}
			if ( ! empty( $settings['padding']['bottom'] ) ) {
				echo 'padding-bottom:' . sanitize_text_field( $settings['padding']['bottom'] ) . ';';
			}
			if ( ! empty( $settings['padding']['left'] ) ) {
				echo 'padding-left:' . sanitize_text_field( $settings['padding']['left'] ) . ';';
			}
		}
	}

	if ( ! empty( $settings['position'] ) ) {
		if ( ! empty( $settings['position']['style'] ) ) {
			echo 'position:' . sanitize_text_field( $settings['position']['style'] ) . ';';
		}
		if ( ! empty( $settings['position']['zindex'] ) ) {
			echo 'z-index:' . sanitize_text_field( $settings['position']['zindex'] ) . ';';
		}
		if ( ! empty( $settings['position']['top'] ) ) {
			echo 'top:' . sanitize_text_field( $settings['position']['top'] ) . ';';
		}
		if ( ! empty( $settings['position']['right'] ) ) {
			echo 'right:' . sanitize_text_field( $settings['position']['right'] ) . ';';
		}
		if ( ! empty( $settings['position']['bottom'] ) ) {
			echo 'bottom:' . sanitize_text_field( $settings['position']['bottom'] ) . ';';
		}
		if ( ! empty( $settings['position']['left'] ) ) {
			echo 'left:' . sanitize_text_field( $settings['position']['left'] ) . ';';
		}
		if ( ! empty( $settings['position']['width'] ) ) {
			echo 'width:' . sanitize_text_field( $settings['position']['width'] ) . ';';
		}
		if ( isset( $settings['position']['opacity'] ) && strlen( $settings['position']['opacity'] ) ) {
			echo 'opacity:' . sanitize_text_field( $settings['position']['opacity'] ) . ';';
		}

		if ( $settings['position']['translatex'] || $settings['position']['translatey'] ) {
			echo 'transform:';
			if ( $settings['position']['translatex'] ) {
				echo ' translateX(' . $settings['position']['translatex'] . ')';
			}
			if ( $settings['position']['translatey'] ) {
				echo ' translateY(' . $settings['position']['translatey'] . ')';
			}
			echo ';';
		}
	}
	echo '}';
}

/* hover style */
if ( ! empty( $settings['hover'] ) ) {

	echo 'html ' . sanitize_text_field( $settings['selector'] ) . ':hover{';
	if ( ! empty( $settings['hover']['bg'] ) ) {
		echo 'background-color:' . sanitize_text_field( $settings['hover']['bg'] ) . ';';
	}
	if ( ! empty( $settings['hover']['color'] ) ) {
		echo 'color:' . sanitize_text_field( $settings['hover']['color'] ) . ';';
	}
	if ( ! empty( $settings['hover']['border_style'] ) ) {
		echo 'border-style:' . sanitize_text_field( $settings['hover']['border_style'] ) . ';';
	}
	if ( isset( $settings['hover']['border_top'], $settings['hover']['border_right'], $settings['hover']['border_bottom'], $settings['hover']['border_left'] ) && strlen( $settings['hover']['border_top'] ) && strlen( $settings['hover']['border_right'] ) && strlen( $settings['hover']['border_bottom'] ) && strlen( $settings['hover']['border_left'] ) ) {
		echo 'border-width:' . sanitize_text_field( $settings['hover']['border_top'] . ' ' . $settings['hover']['border_right'] . ' ' . $settings['hover']['border_bottom'] . ' ' . $settings['hover']['border_left'] ) . ';';
	} else {
		if ( isset( $settings['hover']['border_top'] ) && strlen( $settings['hover']['border_top'] ) ) {
			echo 'border-top-width:' . sanitize_text_field( $settings['hover']['border_top'] ) . ';';
		}
		if ( isset( $settings['hover']['border_right'] ) && strlen( $settings['hover']['border_right'] ) ) {
			echo 'border-right-width:' . sanitize_text_field( $settings['hover']['border_right'] ) . ';';
		}
		if ( isset( $settings['hover']['border_bottom'] ) && strlen( $settings['hover']['bottom'] ) ) {
			echo 'border-bottom-width:' . sanitize_text_field( $settings['hover']['bottom'] ) . ';';
		}
		if ( isset( $settings['hover']['border_left'] ) && strlen( $settings['hover']['border_left'] ) ) {
			echo 'border-left-width:' . sanitize_text_field( $settings['hover']['border_left'] ) . ';';
		}
	}
	if ( ! empty( $settings['hover']['border_color'] ) ) {
		echo 'border-color:' . sanitize_text_field( $settings['hover']['border_color'] ) . ';';
	}
	if ( ! empty( $settings['hover']['top'] ) ) {
		echo 'top:' . sanitize_text_field( $settings['hover']['top'] ) . ';';
	}
	if ( ! empty( $settings['hover']['right'] ) ) {
		echo 'right:' . sanitize_text_field( $settings['hover']['right'] ) . ';';
	}
	if ( ! empty( $settings['hover']['bottom'] ) ) {
		echo 'bottom:' . sanitize_text_field( $settings['hover']['bottom'] ) . ';';
	}
	if ( ! empty( $settings['hover']['left'] ) ) {
		echo 'left:' . sanitize_text_field( $settings['hover']['left'] ) . ';';
	}
	if ( isset( $settings['hover']['opacity'] ) && strlen( $settings['hover']['opacity'] ) ) {
		echo 'opacity:' . floatval( $settings['hover']['opacity'] ) . ';';
	}
	if ( $settings['hover']['translatex'] || $settings['hover']['translatey'] ) {
		echo 'transform:';
		if ( $settings['hover']['translatex'] ) {
			echo ' translateX(' . $settings['hover']['translatex'] . ')';
		}
		if ( $settings['hover']['translatey'] ) {
			echo ' translateY(' . $settings['hover']['translatey'] . ')';
		}
		echo ';';
	}
	echo '}';
}
