<?php
/**
 * Plugin Actions, Filters
 *
 * @author     D-THEMES
 * @package    WP Alpha Core Framework
 * @subpackage Core
 * @version    1.0
 */
defined( 'ABSPATH' ) || die;

add_action( 'after_setup_theme', 'alpha_setup_make_script_async' );
add_action( 'wp_enqueue_scripts', 'alpha_enqueue_core_framework_scripts', 2 );
add_action( 'admin_print_footer_scripts', 'alpha_print_footer_scripts', 30 );
add_action( 'wp_ajax_alpha_load_creative_layout', 'alpha_load_creative_layout' );
add_action( 'wp_ajax_nopriv_alpha_load_creative_layout', 'alpha_load_creative_layout' );

// update image srcset meta
add_filter( 'wp_calculate_image_srcset', 'alpha_image_srcset_filter_sizes', 10, 2 );

if ( ! function_exists( 'alpha_print_footer_scripts' ) ) {
	/**
	 * Print footer scripts
	 *
	 * @since 1.0
	 */
	function alpha_print_footer_scripts() {
		echo '<script id="alpha-core-admin-js-extra">';
		echo 'var alpha_core_vars = ' . json_encode(
			apply_filters(
				'alpha_core_admin_localize_vars',
				array(
					'ajax_url'   => esc_url( admin_url( 'admin-ajax.php' ) ),
					'nonce'      => wp_create_nonce( 'alpha-core-nonce' ),
					'assets_url' => ALPHA_CORE_URI,
					'theme'      => ALPHA_NAME,
				)
			)
		) . ';';
		echo '</script>';
	}
}

if ( ! function_exists( 'alpha_enqueue_core_framework_scripts' ) ) {

	/**
	 * Enqueue framework required scripts
	 *
	 * @since 1.2.0
	 */
	function alpha_enqueue_core_framework_scripts() {
		wp_register_script( 'jquery-floating', alpha_core_framework_uri( '/assets/js/jquery.floating.min.js' ), array( 'jquery-core' ), false, true );
		wp_register_script( 'jquery-skrollr', alpha_core_framework_uri( '/assets/js/skrollr.min.js' ), array(), '0.6.30', true );
		wp_register_script( 'alpha-chart-lib', alpha_core_framework_uri( '/assets/js/chart.min.js' ), array(), false, true );
		wp_register_script( 'three-sixty', alpha_core_framework_uri( '/assets/js/threesixty.min.js' ), array(), false, true );
		wp_register_script( 'jquery-countdown', alpha_core_framework_uri( '/assets/js/jquery.countdown.min.js' ), array(), false, true );
	}
}

if ( ! function_exists( 'alpha_setup_make_script_async' ) ) {
	/**
	 * Add a filter to make scripts async.
	 *
	 * @since 1.0
	 */
	function alpha_setup_make_script_async() {
		// Set scripts as async
		if ( ! alpha_is_wpb_preview() && function_exists( 'alpha_get_option' ) && alpha_get_option( 'resource_async_js' ) ) {
			add_filter( 'script_loader_tag', 'alpha_make_script_async', 10, 2 );
		}
	}
}

if ( ! function_exists( 'alpha_make_script_async' ) ) {
	/**
	 * Set scripts as async
	 *
	 * @since 1.0
	 *
	 * @param string $tag
	 * @param string $handle
	 * @return string Async script tag
	 */
	function alpha_make_script_async( $tag, $handle ) {
		$async_scripts = apply_filters(
			'alpha_async_scripts',
			array(
				'jquery-parallax',
				'jquery-autocomplete',
				'jquery-countdown',
				'alpha-magnific-popup',
				'jquery-cookie',
				'alpha-framework-async',
				'alpha-theme',
				'alpha-shop',
				'alpha-woocommerce',
				'alpha-single-product',
				'alpha-ajax',
				'alpha-countdown',
				'alpha-shop-show-type',
			)
		);

		if ( in_array( $handle, $async_scripts ) ) {
			return str_replace( ' src', ' async="async" src', $tag );
		}
		return $tag;
	}
}

add_filter(
	'alpha_core_filter_doing_ajax',
	function() {
		// check ajax doing on others
		return ( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && mb_strtolower( $_SERVER['HTTP_X_REQUESTED_WITH'] ) == 'xmlhttprequest' ) ? true : false;
	}
);

if ( ! function_exists( 'alpha_load_creative_layout' ) ) {
	function alpha_load_creative_layout() {
		// phpcs:disable WordPress.Security.NonceVerification.NoNonceVerification

		$mode = isset( $_POST['mode'] ) ? $_POST['mode'] : 0;

		if ( $mode ) {
			echo json_encode( alpha_creative_layout( $mode ) );
		} else {
			echo json_encode( array() );
		}

		exit();

		// phpcs:enable
	}
}

if ( ! function_exists( 'alpha_image_srcset_filter_sizes' ) ) {
	/**
	 * Remove srcset in img tag.
	 *
	 * @since 1.2.0
	 */
	function alpha_image_srcset_filter_sizes( $sources, $size_array ) {
		foreach ( $sources as $width => $source ) {
			if ( isset( $source['descriptor'] ) && 'w' == $source['descriptor'] && ( $width < apply_filters( 'alpha_mini_screen_size', 320 ) || (int) $width > (int) $size_array[0] ) ) {
				unset( $sources[ $width ] );
			}
		}
		return $sources;
	}
}
