<?php
/**
 * Core Framework
 *
 * 1. Load the plugin base
 * 2. Load the other plugin functions
 * 3. Load builders
 * 4. Load addons and shortcodes
 * 5. Critical CSS
 *
 * @author     D-THEMES
 * @package    WP Alpha Core Framework
 * @subpackage Core
 * @version    1.0
 */
defined( 'ABSPATH' ) || die;

define( 'ALPHA_CORE_PLUGINS', ALPHA_CORE_FRAMEWORK_PATH . '/plugins' );
define( 'ALPHA_CORE_PLUGINS_URI', ALPHA_CORE_FRAMEWORK_URI . '/plugins' );
define( 'ALPHA_BUILDERS', ALPHA_CORE_FRAMEWORK_PATH . '/builders' );
define( 'ALPHA_BUILDERS_URI', ALPHA_CORE_FRAMEWORK_URI . '/builders' );
define( 'ALPHA_CORE_ADDONS', ALPHA_CORE_FRAMEWORK_PATH . '/addons' );
define( 'ALPHA_CORE_ADDONS_URI', ALPHA_CORE_FRAMEWORK_URI . '/addons' );

global $pagenow;
$alpha_pages = array( 'post-new.php', 'post.php', 'index.php', 'admin-ajax.php', 'edit.php', 'admin.php', 'widgets.php' );
/**************************************/
/* 1. Load the plugin base            */
/**************************************/

require_once alpha_core_framework_path( ALPHA_CORE_FRAMEWORK_PATH . '/common-functions.php' );
require_once alpha_core_framework_path( ALPHA_CORE_FRAMEWORK_PATH . '/plugin-functions.php' );
require_once alpha_core_framework_path( ALPHA_CORE_FRAMEWORK_PATH . '/plugin-actions.php' );

/**
 * Fires after framework init
 *
 * @since 1.0
 */
do_action( 'alpha_after_core_framework_init' );

/**************************************/
/* 2. Load the other plugin functions */
/**************************************/
if ( in_array( $pagenow, $alpha_pages ) ) {

	// @start feature: fs_pb_elementor
	if ( alpha_get_feature( 'fs_pb_elementor' ) ) {
		require_once alpha_core_framework_path( ALPHA_CORE_PLUGINS . '/elementor/class-alpha-core-elementor.php' );   // Elementor
	}
	// @end feature: fs_pb_elementor

}

require_once alpha_core_framework_path( ALPHA_CORE_PLUGINS . '/gutenberg/class-alpha-gutenberg.php' );   //Gutenberg Blocks

// @start feature: fs_plugin_acf
if ( alpha_get_feature( 'fs_plugin_acf' ) && class_exists( 'ACF' ) ) {
	require_once alpha_core_framework_path( ALPHA_CORE_PLUGINS . '/acf/class-alpha-core-acf.php' );                     // ACF
}
// @end feature: fs_plugin_acf

require_once alpha_core_framework_path( ALPHA_CORE_PLUGINS . '/meta-box/class-alpha-admin-meta-boxes.php' );             // Meta Box

if ( class_exists( 'WooCommerce' ) ) {
	require_once alpha_core_framework_path( ALPHA_CORE_PLUGINS . '/woocommerce/class-alpha-core-woocommerce.php' );             // WooCommerce
}

/**
 * Fires after loading framework plugin compatibility.
 *
 * @since 1.0
 */
do_action( 'alpha_after_core_framework_plugins' );

/**************************************/
/* 3. Load builders                   */
/**************************************/
if ( ! isset( $_POST['action'] ) || 'alpha_quickview' != $_POST['action'] ) {
	require_once alpha_core_framework_path( ALPHA_BUILDERS . '/class-alpha-builders.php' );
	// @start feature: fs_builder_sidebar
	if ( alpha_get_feature( 'fs_builder_sidebar' ) ) {
		require_once alpha_core_framework_path( ALPHA_BUILDERS . '/sidebar/class-alpha-sidebar-builder.php' );
	}
	// @end feature: fs_builder_sidebar
}

/**
 * Fires after loading framework template builder.
 *
 * @since 1.0
 */
do_action( 'alpha_after_core_framework_builders' );

/**************************************/
/* 4. Load addons and shortcodes      */
/**************************************/

require_once alpha_core_framework_path( ALPHA_CORE_FRAMEWORK_PATH . '/addons/init.php' );
require_once alpha_core_framework_path( ALPHA_CORE_FRAMEWORK_PATH . '/shortcode.php' );

/**************************************/
/* 5. Critical CSS                    */
/**************************************/

require_once alpha_core_framework_path( ALPHA_CORE_FRAMEWORK_PATH . '/critical/class-alpha-critical.php' );

/**
 * Fires after loading framework init.
 *
 * @since 1.0
 */
do_action( 'alpha_after_core_framework_shortcodes' );
