<?php get_header(); ?>
<div id="text">
    <?php if ( is_404() || is_category() || is_day() || is_month() ||
						is_year() || is_search() || is_paged() ) {
			?> 

			<?php /* If this is a 404 page */ if (is_404()) { ?>
			<?php /* If this is a category archive */ } elseif (is_category()) { ?>
			<h2>Archive for the <?php single_cat_title(''); ?> category</h2>

			<?php /* If this is a yearly archive */ } elseif (is_day()) { ?>
			<h2>Archive for <?php the_time('l, F jS, Y'); ?></h2>

			<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
			<h2>Archive for <?php the_time('F, Y'); ?></h2>

			<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
			<h2>Archive for <?php the_time('Y'); ?></h2>

			<?php /* If this is a monthly archive */ } elseif (is_search()) { ?>
			<h2>Archive for <strong>'<?php the_search_query(); ?>'</strong></h2>

			<?php /* If this is a monthly archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
			<h2>Archive</h2>

			<?php } ?>
				
		 <?php }?>
	<?php if (have_posts()) : ?>
	<?php while (have_posts()) : the_post(); ?>
	<div class="post" id="post-<?php the_ID(); ?>">
        <div class="postinfo">
            <span class="date"><?php the_time('d. m. y') ?></span>
        </div>
        <div class="postcontent">
        	<h2><a href="<?php the_permalink() ?>" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h2>
            <?php the_content('read more...'); ?>
            <?php edit_post_link('edit'); ?>
            <div class="pubinfo"><span class="in"><strong>In: </strong><?php the_category(', ') ?></span><span class="author"><strong>Author: </strong><?php the_author(); ?></span><span class="comments"><?php comments_popup_link('Comments <strong>(0)</strong>', 'Comments <strong>(1)</strong>', 'Comments <strong>(%)</strong>'); ?></span></div>
        </div>
        <div class="cleaner"></div>
	</div>
	<?php endwhile; ?>
        <div id="nav">
            <div class="navleft"><?php previous_posts_link('Older entries') ?></div>
            <div class="navright"><?php next_posts_link('Newer entries') ?></div>
		</div>
	<?php else : ?>
                <h2>Error 404 - Not Found</h2>
                <p class="space">Sorry, but you are looking for something that isn't here.</p>
<?php endif; ?>
</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>