<?php include 'views/shared/_header.php';

use Gosas\Core\Entity\ThreeDPayment;
use Gosas\Core\GarantiPaymentProcess;
use Gosas\Core\Settings\PosSettings;
use Gosas\Core\Enums\RequestMode;

require_once('core/settings/PosSettings.php');
require_once('core/enums/RequestMode.php');
require_once('core/entity/ThreeDPayment.php');
require_once('core/GarantiPaymentProcess.php');

$settings = new PosSettings(RequestMode::Test);
$paymentProcess = new GarantiPaymentProcess();
$params = new ThreeDPayment();
$paymentProcess->PrepareOrder();
$paymentProcess->PrepareCustomer();

$params = $paymentProcess->PrepareThreeDPayment($paymentProcess->request->order->orderId, 100, 949, 1, 'sales');
?>

<div class="card">
    <div class="card-body">
        <form id="payment-form" method="post" role="form" action="https://sanalposprovtest.garanti.com.tr/servlet/gt3dengine">
            <input type="hidden" name="mode" id="mode" value="TEST" />
            <input type="hidden" name="apiversion" id="apiversion" value="512" />
            <input type="hidden" name="terminalprovuserid" id="terminalprovuserid" value="<?php print $settings->provUserId ?>" />
            <input type="hidden" name="terminaluserid" id="terminaluserid" value="<?php print $settings->provUserId3DS ?>" />
            <input type="hidden" name="terminalmerchantid" id="terminalmerchantid" value="<?php print $settings->merchantId ?>" />
            <input type="hidden" name="txntype" id="txntype" value="<?php print $params->type ?>" />
            <input type="hidden" name="txncurrencycode" id="txncurrencycode" value="<?php print $params->currency ?>" />
            <input type="hidden" name="txninstallmentcount" id="txninstallmentcount" value="1" />
            <input type="hidden" name="txnamount" id="txnamount" value="100" />
            <input type="hidden" name="orderid" id="orderid" value="<?php print $paymentProcess->request->order->orderId ?>" />
            <input type="hidden" name="terminalid" id="terminalid" value="<?php print $settings->terminalId ?>" />
            <input type="hidden" name="successurl" id="successurl" value="<?php print $params->successUrl ?>" />
            <input type="hidden" name="errorurl" id="errorurl" value="<?php print $params->errorUrl ?>" />
            <input type="hidden" name="customeremailaddress" id="customeremailaddress" value="<?php print $paymentProcess->request->customer->emailAddress ?>" />
            <input type="hidden" name="customeripaddress" id="customeripaddress" value="<?php print $paymentProcess->request->customer->ipAddress ?>" />
            <input type="hidden" name="companyname" id="companyname" Value="GARANTI TEST" />
            <input type="hidden" name="lang" id="lang" Value="tr" />
            <input type="hidden" name="txntimestamp" id="txntimestamp" value="<?php print date("h:i:sa") ?>" />
            <input type="hidden" name="refreshtime" id="refreshtime" value="1" />
            <input type="hidden" name="secure3dhash" id="secure3dhash" value="<?php print $params->hashedData ?>" />

            <!--Should only have 1-->
            <!-------------------------------------------------------------------------------->
            <!--Common Card / Futures Sale-->
            <input type="hidden" name="secure3dsecuritylevel" id="secure3dsecuritylevel" value="CUSTOM_PAY" />
            <!--Standart 3D Pay-->
            <input type="hidden" name="secure3dsecuritylevel" id="secure3dsecuritylevel" value="3D_PAY" />
            <!--3D Pay FULL-->
            <input type="hidden" name="secure3dsecuritylevel" id="secure3dsecuritylevel" value="3D_FULL" />
            <!--3D Pay HALF-->
            <input type="hidden" name="secure3dsecuritylevel" id="secure3dsecuritylevel" value="3D_HALF" />
            <!-------------------------------------------------------------------------------->

            <!--With Bonus-->
            <input type="text" name="txnrewardcount" value="<?php print $params->hashedPassword ?>"><br>
            <input type="text" name="txnrewardtype1" value="BNS"><br>
            <input type="text" name="txnrewardusedamount1" value="100"><br>

            <!--With FBB-->
            <input type="text" name="txnrewardcount" value="1"><br>
            <input type="text" name="txnrewardtype1" value="FBB"><br>
            <input type="text" name="txnrewardusedamount1" value="100"><br>

            <!--With FBB & Bonus-->
            <input type="text" name="txnrewardcount" value="2"><br>
            <input type="text" name="txnrewardtype1" value="BNS"><br>
            <input type="text" name="txnrewardusedamount1" value="100"><br>
            <input type="text" name="txnrewardtype2" value="FBB"><br>
            <input type="text" name="txnrewardusedamount2" value="100"><br>

            <!--Recuring(Fixed)-->
            <input type="hidden" name="recurringtype" value="R" />
            <input type="hidden" name="totalpaymentnum" value="5" /> <!--Recuring Count-->
            <input type="hidden" name="frequencytype" value="M" /> <!--Month (M), Day(D), Week(W)-->
            <input type="hidden" name="frequencyinterval" value="1" /> <!--1 The number of repetitions (M/D/W)-->
            <input type="hidden" name="startdate" value="20221213" /> <!--YYYYMMDD-->
            <!-- + Recuring(Variable)-->
            <input type="hidden" name="recurringamount1" value="" />
            <input type="hidden" name="recurringamount2" value="" />
            <!-- + ...-->

            <!--With Address-->

            <!--Billing Address-->
            <input type="hidden" name="orderaddresscount" value="1" />
            <input type="hidden" name="orderaddresstype1" value="B" />
            <input type="hidden" name="orderaddresscity1" value="İSTANBUL" />
            <input type="hidden" name="orderaddresscompany1" value="231" />
            <input type="hidden" name="orderaddresscountry1" value="BAĞCILAR" />
            <input type="hidden" name="orderaddressdistrict1" value="3111" />
            <input type="hidden" name="orderaddressfaxnumber1" value="5441" />
            <input type="hidden" name="orderaddressgsmnumber1" value="5445445555" />
            <input type="hidden" name="orderaddresslastname1" value="aaaaa" />
            <input type="hidden" name="orderaddressname1" value="aaaaaaeee333" />
            <input type="hidden" name="orderaddressphonenumber1" value="5445445555" />
            <input type="hidden" name="orderaddresspostalcode1" value="34200" />
            <input type="hidden" name="orderaddresstext1" value="tıkent Carefour Karsısı / Jandarma Kıslası" />

            <!--Shipping Address-->
            <input type="hidden" name="orderaddresstype1" value="S" />
            <input type="hidden" name="orderaddresscity1" value="İSTANBUL" />
            <input type="hidden" name="orderaddresscompany1" value="231" />
            <input type="hidden" name="orderaddresscountry1" value="BAĞCILAR" />
            <input type="hidden" name="orderaddressdistrict1" value="3111" />
            <input type="hidden" name="orderaddressfaxnumber1" value="5441" />
            <input type="hidden" name="orderaddressgsmnumber1" value="5445445555" />
            <input type="hidden" name="orderaddresslastname1" value="aaaaa" />
            <input type="hidden" name="orderaddressname1" value="aaaaaaeee333" />
            <input type="hidden" name="orderaddressphonenumber1" value="5445445555" />
            <input type="hidden" name="orderaddresspostalcode1" value="34200" />
            <input type="hidden" name="orderaddresstext1" value="Tkent Carrefour Karsısı / Jandarma Kıslası" />

            <!--Order Info-->
            <input type="hidden" name="orderitemcount" value="1" />
            <input type="hidden" name="ordercommentnumber1" value="1" />
            <input type="hidden" name="orderproductid1" value="1111" />
            <input type="hidden" name="orderproductcode1" value="2222" />
            <input type="hidden" name="orderquantity1" value="1" />
            <input type="hidden" name="ordertotalamount1" value="1200" />
            <input type="hidden" name="orderdescription1" value="aciklama" />

            <!--Special Info-->
            <input type="hidden" name="ordercommentcount" value="1" />
            <input type="hidden" name="ordercommenttext1" value="Bu alana kullanılmak istenilen bilgi yazılmalı" />
            <input type="hidden" name="ordercommentnumber1" value="1" />

            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col">
                            <div class="card-wrapper">3D'li Ödeme Ekranı</div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label>Ad Soyad</label>
                                <input class="form-control" name="cardholdername" value="Test User" />
                            </div>
                            <div class="form-group">
                                <label>Kart Numarası</label>
                                <input class="form-control" id="cardnumber" name="cardnumber" value="5406697543211173" />
                            </div>
                            <div class="form-group">
                                <label>Son Kullanma (Ay)</label>
                                <input class="form-control" id="cardexpiredatemonth" name="cardexpiredatemonth" value="03" />
                            </div>
                            <div class="form-group">
                                <label>Son Kullanma (Yıl)</label>
                                <input class="form-control" id="cardexpiredateyear" name="cardexpiredateyear" value="23" />
                            </div>
                            <div class="form-group">
                                <label>CVV2</label>
                                <input class="form-control" name="cardcvv2" value="465" />
                            </div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-end mt-3">
                        <button type="submit" class="btn btn-primary">Ödemeyi Tamamla</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<?php include 'views/shared/_footer.php'; ?>