<?php   

session_start();
include('functions/userfunctions.php');
    include('includes/header.php');
    
    $current_hour = date('H'); // Get the current hour in 24-hour format (0-23)


?>
<div class="container mt-5 mb-3 px-3">
    <div class="row text-center">
        <div class="card py-5">
            <h2>
                Organizing Anniversary & Birthday Events 
            </h2>
            <div class="contactrow text-center" style="justify-content: space-evenly;display: flex;">
                <span><a href="mailto:info@exelsiorhotels.com">info@exelsiorhotels.com</a></span><span><a href="tel:+90 542 428 66 02">+90 542 428 66 02</a></span>
            </div>
        </div>
    </div>
</div>
<div class="container mt-5 mb-5"  id="mainnav">
    <div class="row product_data">
        <?php
        //$category_ids = array(56, 19, 42, 43, 53, 51, 52, 54, 50, 42, 43, 44, 45, 46, 47, 48, 49, 24, 18, 17, 16, 15, 14, 20, 23, 25, 22, 21, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41); // referans için bütün kategoriler
        // , 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41   --- alcohols
        if ($current_hour >= 5 && $current_hour < 9) {
            //  08:00 - 12:00 arası
            $category_ids = array(19, 24, 15, 18, 16, 22, 55, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41);
            
        }
        else if(($current_hour >= 9 && $current_hour < 15)){
            //  12:00 - 18:00 arası
            $category_ids = array( 55, 22, 16, 15, 17, 18, 14, 20, 23, 50, 25, 21, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41 );
        }
        else if(($current_hour >= 15 && $current_hour < 20)){
            //  18:00 - 23:00 arası
            $category_ids = array(55, 22, 42, 43, 44, 45, 46, 47, 48, 49, 51, 52, 53, 54, 50, 14, 20, 23, 25, 21, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41);
        }
         else {
            // kapalı saatler dışında hepsini göster - 23:00-08:00
            $category_ids = array(19, 42, 43, 53, 51, 52, 54, 50, 44, 45, 46, 47, 48, 49, 24, 18, 17, 16, 15, 14, 20, 23, 25, 22, 21, 55, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41);
        }
        
        //foreach ($category_ids as $category_id) {
        //  $category_name = getCategoryName($category_id);
        //  echo '<h2 class="mt-4 mb-2" id="'.$category_id.'">'.getCategoryName($category_id).'</h2>';
        //    $allproducts = getProdByCategory($category_id);
        //    if(mysqli_num_rows($allproducts) > 0) {
        //        foreach($allproducts as $item) {
        //            include('includes/indexcatlist.php');
        //        }
        //    } else {
        //        echo "No data available.";
        //    }
        //}


?>
        <style>
    .category-header {
        transition: all 0.7s ease;
        padding: 10px;
        background-color: #f8f9fa;
        border-radius: 5px;
        cursor: pointer;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .category-header:hover {
        background-color: #e9ecef;
    }
    
    .category-content {
        padding: 15px 0;
        overflow: hidden;
        transition: max-height 0.3s ease, opacity 0.2s ease;
        max-height: 0;
        opacity: 0;
    }
    
    .category-content.show {
        max-height: 5000px; /* Adjust this based on your content height */
        opacity: 1;
    }
    
    .chevron-icon {
        transition: transform 0.7s ease;
        margin-left: 30px;
    }
    
    .chevron-icon.rotated {
        transform: rotate(180deg);
    }
</style>


<?php
    $category_name2 = getCategoryName(56); ?>
    
    <div class="category-section">
        <h3 class="my-2 text-center category-header" data-category="<?= 56 ?>">
            <?= $category_name2 ?>
            <i class="fa fa-chevron-down chevron-icon"></i>
        </h3>
        
        <div class="category-content" id="content-<?php echo 56; ?>">
            <?php 
            $allproducts = getProdByCategory(56);
            if(mysqli_num_rows($allproducts) > 0): 
                foreach($allproducts as $item): ?>
                <hr>
                    <div class="row my-2">
                        <div class="col-12">
                            <div class="row">
                                <div class="col-5">
                                    <!--<img src="https://order.exelsiorhotels.com/uploads/<?= $item['image']; ?>jpg" style="width:100%;">-->
                                    
                                    <img src="/uploads/<?= $item['image']; ?>" style="    width: 150px;
    height: 150px;">
                                </div>
                                <div class="col-7">
                                    <div class="row">
                                        <span class=""><?= $item['name']; ?></span>
                                        <span class="m-0"><?= $item['small_description']; ?></span>
                                    </div>
                                    <div class="row">
                                        <p class="text-success fw-bold" style="text-align: end; float: right;"><?= $item['selling_price'];?><span style="padding-left:0px;"> ₺</span></p>
                                        <div class="d-flex" style="height:auto;gap:5px;float: right;justify-content: end;">
                                            <div class="input-group mb-1" style="width:50%!important;height: 30px;margin-right: 30px;">
                                                <button class="input-group-text decrement-btn">-</button>
                                                <input type="text" class="form-control bg-white input-qty text-center" value="1" disabled="">
                                                <button class="input-group-text increment-btn">+</button>
                                            </div>
                                            <button class="btn btn-primary px-4 addToCartBtn" value="<?= $item['id'];?>">
                                                Add 
                                            </button>
                                        </div>
                                    </div>    
                                </div>
                            </div>
                        </div>
                    </div>
                    
                <?php endforeach; 
            else: ?>
                <p>No data available.</p>
            <?php endif; ?>
        </div>
    </div>

<?php
 foreach ($category_ids as $category_id): 
    $category_name = getCategoryName($category_id); ?>
    
    <div class="category-section">
        <h3 class="my-2 text-center category-header" data-category="<?= $category_id ?>">
            <?= $category_name ?>
            <i class="fa fa-chevron-down chevron-icon"></i>
        </h3>
        
        <div class="category-content" id="content-<?= $category_id ?>">
            <?php 
            $allproducts = getProdByCategory($category_id);
            if(mysqli_num_rows($allproducts) > 0): 
                foreach($allproducts as $item): ?>
                <hr>
                    <div class="row my-2">
                        <div class="col-12">
                            <div class="row">
                                <div class="col-6">
                                    <h6 class=""><?= $item['name']; ?></h6>
                                    <p class="m-0"><?= $item['small_description']; ?></p>
                                </div>
                                <div class="col-6">
                                    <p class="text-success fw-bold" style="text-align: end;"><?= $item['selling_price'];?><span style="padding-left:0px;"> ₺</span></p>
                                    <div class="d-flex" style="height:auto;gap:5px;">
                                        <div class="input-group mb-1" style="width:90px;height:10px;">
                                            <button class="input-group-text decrement-btn">-</button>
                                            <input type="text" class="form-control bg-white input-qty text-center" value="1" disabled>
                                            <button class="input-group-text increment-btn">+</button>
                                        </div>
                                        <button class="btn btn-primary px-4 addToCartBtn" value="<?= $item['id'];?>">
                                            Add 
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> 
                <?php endforeach; 
            else: ?>
                <p>No data available.</p>
            <?php endif; ?>
        </div>
    </div>
<?php endforeach; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const categoryHeaders = document.querySelectorAll('.category-header');
    
    categoryHeaders.forEach(header => {
        header.addEventListener('click', function() {
            const categoryId = this.getAttribute('data-category');
            const content = document.getElementById(`content-${categoryId}`);
            const icon = this.querySelector('.chevron-icon');
            
            // Close all other categories
            document.querySelectorAll('.category-content').forEach(item => {
                if (item !== content) {
                    item.classList.remove('show');
                    const otherIcon = item.previousElementSibling.querySelector('.chevron-icon');
                    otherIcon.classList.remove('rotated');
                }
            });
            
            // Toggle current category
            content.classList.toggle('show');
            icon.classList.toggle('rotated');
        });
    });
});
</script>
    </div>
</div>


    <?php include('includes/footer.php');?>