<nav class="navbar navbar-expand-lg navbar-light shadow sticky-top bg-white">
  <div class="container mobilenavbarwrap">
    <a class="navbar-brand" href="index.php">
      <img class="img-fluid" src="assets/img/logo.png" width="70%" alt="logo">
    </a>
    <?php
      $items = getCartItems();

    ?>
    <div class="float-end cart-icon rounded-circle">
      <a class="nav-link rounded-circle" href="cart.php">
        <i class="fa fa-shopping-cart 2xl position-relative">
          <?php if(mysqli_num_rows($items) > 0) : ?>
            <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger"><?= $cartItemCount ?></span>
          <?php endif; ?>
        </i>
      </a>
    </div>
    <script>
document.addEventListener('DOMContentLoaded', function() {
    // Check if there are items in the cart (you may need to customize this logic)
    var cartItemCount = <?php echo json_encode(mysqli_num_rows($items)); ?>;

    // Get the red dot badge element
    var redDot = document.querySelector('.cart-icon .badge');

    // Show red dot if cart has items
    if (cartItemCount > 0) {
        redDot.style.display = 'block';
        redDot.innerText = cartItemCount; // Optionally display the item count
    } else {
        redDot.style.display = 'none';
    }
});
</script>
    <div class="cart-icon2 rounded-circle">
      <a class="nav-link rounded-circle" href="#mainnav"><i class="fa fa-arrow-up" aria-hidden="true"></i></a>
    </div>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav ms-auto">
        <li class="nav-item">
          <a class="nav-link active" aria-current="page" href="index.php">Menu</a>
        </li>
        <?php
        if(isset($_SESSION['auth'])){
          ?>
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="register.php" id="navbarDropdownMenuLink" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            <?=$_SESSION['auth_user']['name'];?></a>
            <ul class="dropdown-menu">
              <?php 
              if($_SESSION['role_as'] == 1)
              {
                ?>
              <li><a class="dropdown-item" href="https://order.exelsiorhotels.com/admin/">Admin Panel</a></li>
              <?php
              }
              else if($_SESSION['role_as'] == 0)
              {
                ?>
              <li><a class="dropdown-item" href="my-orders.php">Order History</a></li>
              <?php
              }
              ?>
              <li><a class="dropdown-item" href="logout.php">Logout</a></li>
            </ul>
        </li>
          <?php
        }
        else
        {
          ?>
        <li class="nav-item">
          <a class="nav-link" href="register.php">Register</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="login.php">Login</a>
        </li>
        <?php
                }
                ?>
        <li class="nav-item">
          <a class="nav-link" href="cart.php"><i class="fa fa-shopping-cart"></i></a>
        </li>        
      </ul>
    </div>
  </div>
<!-- top category menu
<div class="container">
      <div class="customcard shadow">
        <?php
          if (basename($_SERVER['PHP_SELF']) === 'index.php' || basename($_SERVER['REQUEST_URI']) === 'index.php') {
            $current_hour = date('H');
            if ($current_hour >= 5 && $current_hour < 15) {
              //  08:00 - 18:00 arası
              $category_ids = array(19, 42, 43, 50, 24, 18, 17, 16, 15, 14, 20, 23, 25, 22, 21, 55, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41);
              //$category_ids = array(19, 42, 43, 53, 51, 52, 54, 50, 42, 43, 44, 45, 46, 47, 48, 49, 24, 18, 17, 16, 15, 14, 20, 23, 25, 22, 21, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41); // referans için bütün kategoriler
          } else if(($current_hour >= 15 && $current_hour < 20)){
              //  18:00 - 23:00 arası
              $category_ids = array(43, 53, 51, 52, 54, 50, 42, 43, 44, 45, 46, 47, 48, 49, 14, 20, 23, 25, 55, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41);
          } else {
              // kapalı saatler dışında hepsini göster - 23:00-08:00
              $category_ids = array(19, 42, 43, 53, 51, 52, 54, 50, 44, 45, 46, 47, 48, 49, 24, 18, 17, 16, 15, 14, 20, 23, 25, 22, 21, 55, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41);
          }
              foreach ($category_ids as $category_id) {
                  $category_name = getCategoryName($category_id);
                  //echo '<div class="col-md-2">';
                  echo '<span><a class="nav-link2" href="#'.$category_id.'">'.getCategoryName($category_id).'</a></span>'; 
                  //echo '</div>';
              }
          }
        ?>
      </div>
  </div>
  -->
  </nav>
