<?php
error_reporting(E_ALL); 
ini_set('display_errors', 1);
require 'functions/userfunctions.php';
include('config/dbcon.php');
include('includes/header.php');
include('authenticate.php');

// Retrieve POST data
$name = mysqli_real_escape_string($con, $_POST['name']);
$email = mysqli_real_escape_string($con, $_POST['email']);
$phone = mysqli_real_escape_string($con, $_POST['phone']);
$pincode = mysqli_real_escape_string($con, $_POST['pincode']);
$address = mysqli_real_escape_string($con, $_POST['address']);
$payment_mode = mysqli_real_escape_string($con, $_POST['payment_mode']);
$totalPrice = mysqli_real_escape_string($con, $_POST['totalprice']);

// Generate unique tracking number
$tracking_no = "yaka" . rand(1111, 9999) . substr($phone, 2);
$user_id = $_SESSION['auth_user']['user_id'];

// Generate hash data for payment
$orderId = $tracking_no;

$terminalId = 30691297; // Example terminal ID (must be integer)
$amount = $totalPrice; // Example amount

$currencyCode = 949; // Example currency code (e.g., 949 for Turkish Lira)
$successUrl = "https://order.exelsiorhotels.com/my-orders.php?url=login.php";
$errorUrl = "https://order.exelsiorhotels.com/paymentfailed.php";
$type = "sales";
$installmentCount = "";
$storeKey = 12345678;

// Generate hash data using the function
$shaData2 = GenerateSecurityData($terminalId);
$hashData2 = $terminalId . $orderId . $amount . $currencyCode . $successUrl . $errorUrl . $type . $installmentCount . $storeKey . $shaData2;
$hashData = GenerateHashData($terminalId, $orderId, $amount, $currencyCode, $successUrl, $errorUrl, $type, $installmentCount, $storeKey, $shaData2);

// Check if required fields are empty
if ($name == "" || $email == "" || $phone == "" || $pincode == "" || $address == "") {
    $_SESSION['message'] = "All fields are required";
    header('Location: ../checkout.php');
    exit(0);
}
echo "sha1= " . $shaData2;
echo "secure3dhash= " . $hashData;
echo "hastt2= " . $hashData2;
?>

<div class="container py-5">
    <div class="card">
        <div class="card-body shadow">
            <form method="post" action="https://sanalposprovtest.garantibbva.com.tr/servlet/gt3dengine">
                <div class="row">
                    <div class="col-12">
                        <h5>Card Information</h5>
                        <hr>
                        <div class="row">
                            <!-- Hidden input fields for payment form -->
                            <input type="hidden" name="mode" value="TEST" />
                            <input type="hidden" name="apiversion" value="512" />
                            <input type="hidden" name="secure3dsecuritylevel" value="3D_PAY" />
                            <input type="hidden" name="terminalprovuserid" value="PROVAUT" />
                            <input type="hidden" name="terminaluserid" value="GARANTI" />
                            <input type="hidden" name="terminalmerchantid" value="7000679" />
                            <input type="hidden" name="terminalid" value="<?php echo $terminalId;?>" />
                            <input type="hidden" name="orderid" value="<?php echo $tracking_no; ?>" />
                            <input type="hidden" name="successurl" value="<?php echo $successUrl; ?>" />
                            <input type="hidden" name="errorurl" value="<?php echo $errorUrl; ?>" />
                            <input type="hidden" name="customeremailaddress" value="eticaret@garanti.com.tr" />
                            <input type="hidden" name="customeripaddress" value="192.168.0.1" />
                            <input type="hidden" name="companyname" value="GARANTI TEST" />
                            <input type="hidden" name="lang" value="tr" />
                            <input type="hidden" name="txntimestamp" value="<?php echo date("Y-m-d H:i:s"); ?>" />
                            <input type="hidden" name="refreshtime" value="1" />
                            <input type="hidden" name="secure3dhash" value="<?php echo $hashData; ?>" />
                            <input type="hidden" name="txnamount" value="<?php echo $totalPrice; ?>" />
                            <input type="hidden" name="txntype" value="sales" />
                            <input type="hidden" name="txncurrencycode" value="<?php echo $currencyCode;?>" />
                            <input type="hidden" name="txninstallmentcount" value="" />

                            <div class="col-md-6 mb-3">
                                <label class="fw-bold">Name</label>
                                <input type="text" name="cardholdername" required placeholder="Name on card" class="form-control">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="fw-bold">Card Number</label>
                                <input type="number" name="cardnumber" required placeholder="Card number" class="form-control">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="fw-bold">Month</label>
                                <input type="number" name="cardexpiredatemonth" required placeholder="Month" class="form-control">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="fw-bold">Year</label>
                                <input type="number" name="cardexpiredateyear" required placeholder="Year" class="form-control">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="fw-bold">CVV</label>
                                <input type="number" name="cardcvv2" required placeholder="CVV" class="form-control">
                            </div>
                            <div class="col-12">
                                <button type="submit" name="placeOrderBtn23" class="btn btn-primary mt-3 w-100">Proceed to Payment</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php include('includes/footer.php'); ?>
