<?php

  function gallery_metabox_enqueue($hook) {
    if ( 'post.php' == $hook || 'post-new.php' == $hook ) {
      wp_enqueue_script('gallery-metabox', get_template_directory_uri() . '/plugins/gallery-metabox/js/gallery-metabox.js', array('jquery', 'jquery-ui-sortable'));
      wp_enqueue_style('gallery-metabox', get_template_directory_uri() . '/plugins/gallery-metabox/css/gallery-metabox.css');
    }
  }
  add_action('admin_enqueue_scripts', 'gallery_metabox_enqueue');

  function add_gallery_metabox($post_type) {
    $types = array('post', 'page', 'tours');

    if (in_array($post_type, $types)) {
      add_meta_box(
        'gallery-metabox',
        'Galeri',
        'gallery_meta_callback',
        $post_type,
        'normal',
        'high'
      );
    }
  }
  add_action('add_meta_boxes', 'add_gallery_metabox');

  function gallery_meta_callback($post) {
    wp_nonce_field( basename(__FILE__), 'gallery_meta_nonce' );
    $ids = get_post_meta($post->ID, 'vdw_gallery_id', true);
 $ids = unserialize($ids);
    ?>
    <table class="form-table">
      <tr><td>
        <a class="gallery-add button" href="#" data-uploader-title="Add image(s) to gallery" data-uploader-button-text="Add image(s)">Resim Ekle</a>

        <ul id="gallery-metabox-list">
        <?php // if ($ids) : foreach ($ids as $key => $value) : $image = wp_get_attachment_image_src($value); ?>
        <?php if ($ids) : foreach ($ids as $key) : $image = wp_get_attachment_image_src($key['id']); ?>

          <li>
              <input type="textbox" name="vdw_gallery_id_head[]" style="width: 100%; font-size:10px;" placeholder="Header" value="<?php echo $key['head']; ?>">
              <input type="textbox" name="vdw_gallery_id_slogan[]"  style="width: 100%; font-size:10px;" placeholder="Başlık 2" value="<?php echo $key['slogan']; ?>">
            <input type="hidden" name="vdw_gallery_id[]" value="<?php echo $key['id']; ?>">
            <img class="image-preview" src="<?php echo $image[0]; ?>">
            <a class="change-image button button-small" href="#" data-uploader-title="DEĞİŞTİR" data-uploader-button-text="DEĞİŞTİR" style="float:left;">DEĞİŞTİR</a><br>
            <a class="remove-image button button-small" href="#" style="float:right;">SİL</a>
          </li>

        <?php endforeach; endif; ?>
        </ul>

      </td></tr>
    </table>
  <?php }

  function gallery_meta_save($post_id) {
    if (!isset($_POST['gallery_meta_nonce']) || !wp_verify_nonce($_POST['gallery_meta_nonce'], basename(__FILE__))) return;

    if (!current_user_can('edit_post', $post_id)) return;

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    /*if(isset($_POST['vdw_gallery_id'])) {*/
      update_post_meta($post_id, 'vdw_gallery_id', $_POST['vdw_gallery_id']);/*

    } else {
      delete_post_meta($post_id, 'vdw_gallery_id');
    }
  }*/

        $vdw_gallery_id = $_POST['vdw_gallery_id'];
		array($vdw_gallery_id);

        $vdw_gallery_id_head = $_POST['vdw_gallery_id_head'];
        $vdw_gallery_id_slogan = $_POST['vdw_gallery_id_slogan'];
		array($vdw_gallery_id_head);
		array($vdw_gallery_id_slogan);

   	    $vdw_gallery_id_count = sizeof($vdw_gallery_id);

		$extra_dr = array();
		$content = '';

		for ($i = 0; $i <= $vdw_gallery_id_count; $i++) {
			$vdw_gallery_ids = $vdw_gallery_id[$i];
			$vdw_gallery_id_heads    = $vdw_gallery_id_head[$i];
			$vdw_gallery_id_slogans    = $vdw_gallery_id_slogan[$i];

 if (empty($vdw_gallery_id_heads)) {

 $vdw_gallery_id_heads  = '';
 $vdw_gallery_id_slogans  = '';
 }

            if (!empty($vdw_gallery_ids)) {
				$extra_dr[] = array(
					'id' => $vdw_gallery_ids,
					'head'   => $vdw_gallery_id_heads,
					'slogan'   => $vdw_gallery_id_slogans,
				);
			}
		}


		if ( sizeof($extra_dr) > 0 ) {
			$content = serialize($extra_dr);
		}

		if(isset($content)) {
		  update_post_meta($post_id, 'vdw_gallery_id', $content);
		} else {
		  delete_post_meta($post_id, 'vdw_gallery_id');
		}


  }
  add_action('save_post', 'gallery_meta_save');

?>
