<?php

add_action('admin_init', 'my_contact_contact');
function my_contact_contact() {
    add_settings_section(
        'my_settings_contact',
        'İletişim Bilgileri',
        'my_contact_options_callback',
        'general'
    );

    add_settings_field(
        'telefon',
        'Telefon',
        'my_contact_textbox_callback',
        'general',
        'my_settings_contact',
        array(
            'telefon'
        )
    );

    add_settings_field( // Option 2
        'info_email', // Option ID
        'Info e-mail', // Label
        'my_contact_textbox_callback', // !important - This is where the args go!
        'general', // Page it will be displayed
        'my_settings_contact', // Name of our contact (General Settings)
        array( // The $args
            'info_email' // Should match Option ID
        )
    );

    register_setting('general','telefon', 'esc_attr');
    register_setting('general','info_email', 'esc_attr');
}

function my_contact_options_callback() { // Section Callback
    echo '<p>Footerda gözükecek iletişim bilgileri</p>';
}

function my_contact_textbox_callback($args) {  // Textbox Callback
    $option = get_option($args[0]);
    echo '<input style="width:300px" type="text" id="'. $args[0] .'" name="'. $args[0] .'" value="' . $option . '" />';
}
