<?php
function service_create_post_type() {
	$labels = array(
		'name' => 'Servisler',
		'singular_name' => 'Servis',
		'add_new' => 'Servis Ekle',
		'all_items' => 'Servisler',
		'add_new_item' => 'Servis Ekle',
		'edit_item' => 'Düzenle',
		'new_item' => 'Yeni Servis',
		'view_item' => 'Görüntüle',
		'search_items' => 'Ara',
		'not_found' => 'Bölüm bulunamadı',
		'not_found_in_trash' => 'Çöp boş',
		'parent_item_colon' => 'Üst'
	);
	$args = array(
		'labels' => $labels,
		'public' => true,
		'has_archive' => true,
		'publicly_queryable' => true,
		'query_var' => true,
		'rewrite' => true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'supports' => array(
			'title',
      'thumbnail',
			'editor'
		),
		'register_meta_box_cb' => 'service_add_post_type_metabox',
		'menu_position' => 4
	);
	register_post_type( 'service', $args );
}
add_action( 'init', 'service_create_post_type' );


function service_add_post_type_metabox() { // add the meta box
  add_meta_box( 'service_metabox', 'Service', 'service_metabox', 'service', 'normal' );
}

function service_metabox() {
  global $post;
  echo '<input type="hidden" name="service_post_noncename" value="' . wp_create_nonce( plugin_basename(__FILE__) ) . '" />';
  $price = get_post_meta($post->ID, 'price', true);
  $ourprice = get_post_meta($post->ID, 'ourprice', true);
  ?>

  <table class="table">
    <tr>
      <th><label>Avrupa Fiyatı</label></th>
      <td>
        <input type="text" name="price" class="regular-text" value="<?php echo $price; ?>">
      </td>
    </tr> 
	<tr>
      <th><label>Bizdeki Fiyat</label></th>
      <td>
        <input type="text" name="ourprice" class="regular-text" value="<?php echo $ourprice; ?>">
      </td>
    </tr>
  </table>
<?php
}

function service_post_save_meta( $post_id, $post ) {
  if ( ! isset( $_POST['service_post_noncename'] ) ) return;
  if( !wp_verify_nonce( $_POST['service_post_noncename'], plugin_basename(__FILE__) ) ) {
    return $post->ID;
  }
  if( ! current_user_can( 'edit_post', $post->ID )){
    return $post->ID;
  }

  $service_post_meta['price'] = $_POST['price'];
  $service_post_meta['ourprice'] = $_POST['ourprice'];

  foreach( $service_post_meta as $key => $value ) {
    $value = implode(',', (array)$value);
    if( get_post_meta( $post->ID, $key, FALSE ) ) {
      update_post_meta($post->ID, $key, $value);
    } else {
      add_post_meta( $post->ID, $key, $value );
    }
    if(!$value) {
      delete_post_meta( $post->ID, $key );
    }
  }
}
add_action( 'save_post', 'service_post_save_meta', 1, 2 );
?>
