<?php
function yorum_create_post_type() {
	$labels = array(
		'name' => 'Yorumlar',
		'singular_name' => 'Yorum',
		'add_new' => 'Yorum Ekle',
		'all_items' => 'Yorumlar',
		'add_new_item' => 'Yorum Ekle',
		'edit_item' => 'Düzenle',
		'new_item' => 'Yeni Yorum',
		'view_item' => 'Görüntüle',
		'search_items' => 'Ara',
		'not_found' => 'Bölüm bulunamadı',
		'not_found_in_trash' => 'Çöp boş',
		'parent_item_colon' => 'Üst yorum'
	);
	$args = array(
		'labels' => $labels,
		'public' => true,
		'has_archive' => true,
		'publicly_queryable' => true,
		'query_var' => true,
		'rewrite' => true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'supports' => array(
			'title',
      'editor'
		),
		'menu_position' => 6,
		'register_meta_box_cb' => 'yorum_add_post_type_metabox'
	);
	register_post_type( 'yorum', $args );
}
add_action( 'init', 'yorum_create_post_type' );

add_filter( 'enter_title_here', 'custom_enter_title' );
function custom_enter_title( $input ) {
    global $post_type;

    if ( is_admin() && 'yorum' == $post_type )
        return __( 'Yazarın Adı', 'your_textdomain' );

    return $input;
}

function getConfirmedComments() {
  $args = array(
		'posts_per_page'  => -1,
		'orderby'         => 'menu_order',
		'order'           => 'DESC',
		'post_type'       => 'yorum',
		'post_status'     => 'publish',
		'meta_query' => array(
       array(
           'key' => 'onay',
           'value' => 1,
           'compare' => '='
       )
    )
	);

	return get_posts( $args );
}

function yorum_add_post_type_metabox() { // add the meta box
  add_meta_box( 'yorum_metabox', 'Yorum Bilgileri', 'yorum_metabox', 'yorum', 'normal' );
}

function yorum_metabox() {
  global $post;
  // Noncename needed to verify where the data originated
  echo '<input type="hidden" name="yorum_post_noncename" value="' . wp_create_nonce( plugin_basename(__FILE__) ) . '" />';

  // Get the data if its already been entered
  $email = get_post_meta($post->ID, 'email', true);
  $onay = get_post_meta($post->ID, 'onay', true);

  ?>

	<style>
		table {
			text-align: left
		}
	</style>

  <table class="table">
    <tr>
      <th>
        <label>Email</label>
      </th>
      <td>
        <input type="email" name="email" value="<?php echo $email; ?>">
      </td>
    </tr>
		<tr>
      <th>
        <label>Onay Ver</label>
      </th>
      <td>
        <input type="checkbox" name="onay" value="1" <?php if($onay) echo 'checked'; ?>>
      </td>
    </tr>
  </table>

<?php
}

function yorum_post_save_meta( $post_id, $post ) { // save the data

  if ( ! isset( $_POST['yorum_post_noncename'] ) ) { // Check if our nonce is set.
    return;
  }

  // verify this came from the our screen and with proper authorization,
  // because save_post can be triggered at other times
  if( !wp_verify_nonce( $_POST['yorum_post_noncename'], plugin_basename(__FILE__) ) ) {
    return $post->ID;
  }

  // is the user allowed to edit the post or page?
  if( ! current_user_can( 'edit_post', $post->ID )){
    return $post->ID;
  }

	$yorum_post_meta['onay'] = $_POST['onay'];
	$yorum_post_meta['email'] = $_POST['email'];

  foreach( $yorum_post_meta as $key => $value ) { // cycle through the $Gulet_post_meta array
    // if( $post->post_type == 'revision' ) return; // don't store custom data twice
    $value = implode(',', (array)$value); // if $value is an array, make it a CSV (unlikely)
    if( get_post_meta( $post->ID, $key, FALSE ) ) { // if the custom field already has a value
      update_post_meta($post->ID, $key, $value);
    } else { // if the custom field doesn't have a value
      add_post_meta( $post->ID, $key, $value );
    }
    if( !$value ) { // delete if blank
      delete_post_meta( $post->ID, $key );
    }
  }
}
add_action( 'save_post', 'yorum_post_save_meta', 1, 2 );

// require_once 'price-module-yorum.php';


// AJAX

function send_comment_ajax() {
  if ( isset($_REQUEST) ) {

    $params = array();
    parse_str($_POST['post_data'], $params);

		$my_post = array(
			'post_title'    => valIn($params["name_surname"]),
			'post_content'  => sanitize_text_field($params["message"]),
			'post_type' => 'yorum',
			'post_status'   => 'publish',
		);
		$post_id = wp_insert_post($my_post);
		add_post_meta($post_id, 'email', valIn($params["email"]), true);
		add_post_meta($post_id, 'onay', "0", true);

		echo(json_encode(['success' => true]));
		die();

    $mailTo       = 'info@grandvillasolmarmaris.com';
    $mailTitle    = get_bloginfo("name") . ' Yeni Yorum Maili';
    $mailTemplate = '
      <h1>'.$mailTitle.'</h1>
      <table>
        <tr>
          <td>İsim:</td>
          <td>'.$params["name_surname"].'</td>
        </tr>
        <tr>
          <td>E-mail:</td>
          <td>'.$params["email"].'</td>
        </tr>
        <tr>
          <td>Mesaj:</td>
          <td>'.$params["message"].'</td>
        </tr>
      </table>
    ';

    $status = wp_mail($mailTo, $mailTitle, $mailTemplate);
    if ($status) {
			// insert into admin
			$my_post = array(
				'post_title'    => $params["name_surname"],
				'post_content'  => sanitize_text_field($params["message"]),
				'post_type' => 'yorum',
				'post_status'   => 'publish',
			);
			$post_id = wp_insert_post($my_post);
			add_post_meta($post_id, 'email', $params["email"], true);
			add_post_meta($post_id, 'onay', "0", true);

      echo(json_encode(['success' => true]));
      die();
    }
  }

  die();
}

add_action( 'wp_ajax_send_comment_ajax', 'send_comment_ajax' );
add_action( 'wp_ajax_nopriv_send_comment_ajax', 'send_comment_ajax' );
