<?php
function event_create_post_type() {
	$labels = array(
		'name' => 'Event',
		'singular_name' => 'Event',
		'add_new' => 'Event Add',
		'all_items' => 'Event',
		'add_new_item' => 'Event Add',
		'edit_item' => 'Edit',
		'new_item' => 'New Event',
		'view_item' => 'Search',
		'search_items' => 'Ara',
		'not_found' => 'Not Found',
		'not_found_in_trash' => 'Empty Trash',
		'parent_item_colon' => 'Top'
	);
	$args = array(
		'labels' => $labels,
		'public' => true,
		'has_archive' => true,
		'publicly_queryable' => true,
		'query_var' => true,
		'rewrite' => true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'supports' => array(
			'title',
      'editor',
      'thumbnail'
		),
		'menu_position' => 4
	);
	register_post_type( 'event', $args );

	register_taxonomy( 'type', // register custom taxonomy - category
		'event',
		array(
			'hierarchical' => true,
			'labels' => array(
				'name' => 'Event Categories',
				'singular_name' => 'Category',
			),
			'rewrite' => array( 'slug' => 'type' )
		)
	);
}
add_action( 'init', 'event_create_post_type' );


?>
