<?php

function purl() {
  return get_bloginfo('template_directory');
}

/* formlarda html ve mysql komut girilmesine engel olur
Usage: $txtName = valIn($_POST['name']);
*/
function valIn($data) {
  $data = trim($data);
  $data = esc_html($data);
  $data = esc_sql($data);
  return $data;
}

function lang() {
  return substr(get_bloginfo( 'language' ), 0, 2);
}

/* Usage:
<img src="<?=getFeaturedUrl($post->ID, 'thumbnail')?>" />
*/
function getFeaturedUrl($post_id, $size) {
  $thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post_id), $size);
  if($thumb) {
    return $thumb[0];
  }
  return "";
}

/* Usage:
<?php
$images = getGallery($post->ID);
foreach($images as $image) {?>
<img src="<?=$image['thumbnail']?>" />
<?php } ?>
*/
function getGallery($post_id) {
  $ret = array();
  $images = unserialize(get_post_meta($post_id, 'vdw_gallery_id', true));
  if ($images) {
    foreach ($images as $image) {
      $thumbnail = wp_get_attachment_image_src($image['id'],'thumbnail')[0];
      $large = wp_get_attachment_image_src($image['id'],'large')[0];
      $full = wp_get_attachment_image_src($image['id'],'full')[0];
      $alt = get_post_meta($image['id'], '_wp_attachment_image_alt', true);

      $ret[] = array(
        'thumbnail' => $thumbnail,
        'large' => $large,
        'full' => $full,
        'alt' => $alt
      );
    }
  }
	return $ret;
}

/* Usage:
$paged = (get_query_var('paged')) ? absint(get_query_var('paged')) : 1; $args = array(
  'post_type' => "yacht",
  'post_status' => 'publish',
  'posts_per_page' => 5,
  'paged' => $paged
);
*/
function paginationLinks( $query=null ) {
  global $wp_query;
  $query = $query ? $query : $wp_query;$big = 999999999;

  $paginate = paginate_links(array(
     'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
     'type' => 'array',
     'total' => $query->max_num_pages,
     'prev_next'          => True,
     'prev_text'          => __(' « '),
     'next_text'          => __(' » '),
     'format' => '?paged=%#%',
     'current' => max( 1, get_query_var('paged') ),
   )
  );

  if ($query->max_num_pages > 1) {
    echo '<ul class="pagination">';
    foreach ($paginate as $page) echo '<li>' . $page . '</li>';
    echo '</ul>';
  }
}

class Currencies {
  public $usd, $gbp, $eur;

  function __construct($usd, $gbp, $eur) {
		$this->usd = $usd;
		$this->gbp = $gbp;
		$this->eur = $eur;
	}
}

/* Usage:
  echo $_SESSION['kurlar']->usd;
  echo $_SESSION['kurlar']->usd;
  echo $_SESSION['kurlar']->usd;

  NOTE: oznet depodaki template'i kullanmıyorsanız;

  functions içine;
  if (!isset($_SESSION['kurlar'])) {
    $_SESSION['kurlar'] = fetchCurrencies();
  }

  kullanıyorsanız constants içinden STORE_CURRENCIES i true yapın
*/

function fetchCurrencies() {
  $url = "http://www.tcmb.gov.tr/kurlar/today.xml";
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_TIMEOUT, 15);
  $res = curl_exec($ch);
  curl_close($ch);
  $xml = simplexml_load_string($res);

  foreach ($xml->Currency as $currency) {
    switch ($currency['Kod']) {
      case 'USD':
        $usd = $currency->ForexBuying;
        break;
      case 'EUR':
        $eur = $currency->ForexBuying;
        break;
      case 'GBP':
        $gbp = $currency->ForexBuying;
        break;
      default:
        break;
    }
  }
  return new Currencies($usd, $eur, $gbp);
}

