<?php
session_start();

include_once 'constants.php';

// Add modules
$modules = [
'lib/modules/contact/contact.php',
//'lib/modules/service.php',
'lib/modules/guestbook/yorumlar.php',
'lib/modules/teklif.php',
'lib/modules/imkan.php',
'lib/modules/etkinlik.php',
];

add_filter( 'wp_mail_content_type', 'set_html_content_type' );
function set_html_content_type() { return 'text/html'; }

foreach ($modules as $module) {
  if (!$filepath = locate_template($module)) {
    trigger_error(sprintf(__('Error locating %s for inclusion', 'sage'), $module), E_USER_ERROR);
  }
  require_once $filepath;
}
unset($file, $filepath);

// activate currencies
if (STORE_CURRENCIES && !isset($_SESSION['kurlar'])) {
  $_SESSION['kurlar'] = fetchCurrencies();
}

// Menus
register_nav_menu( 'primary', __( 'menu1', 'site' ) );


// Theme supports
add_theme_support( 'post-thumbnails' );

// Hidden Pages
function my_remove_menu_pages() {
  remove_menu_page('tools.php');
  remove_menu_page('edit-comments.php');
}
add_action( 'admin_menu', 'my_remove_menu_pages' );

// Custom Login Logo
function my_login_logo() { ?>
  <style type="text/css">
    body.login div#login h1 a {
      background-image: url(<?php echo get_stylesheet_directory_uri()."/img/".LOGO_PATH; ?>);
      background-size: contain;
    }
  </style>
<?php }
add_action( 'login_enqueue_scripts', 'my_login_logo' );

function my_login_logo_url() {
  return home_url();
}
add_filter( 'login_headerurl', 'my_login_logo_url' );

function my_login_logo_url_title() {
  return get_bloginfo('name');
}
add_filter( 'login_headertitle', 'my_login_logo_url_title' );

// Remove WP Logo
function annointed_admin_bar_remove() {
  global $wp_admin_bar;
  $wp_admin_bar->remove_menu('wp-logo');
}
add_action( 'wp_before_admin_bar_render', 'annointed_admin_bar_remove', 0 );

// Dont show update notice except admin
function hide_update_notice_to_all_but_admin_users() {
  if (!current_user_can('update_core')) {
      remove_action( 'admin_notices', 'update_nag', 3 );
  }
}
add_action( 'admin_head', 'hide_update_notice_to_all_but_admin_users', 1 );

// Replace admin footer with bloginfo name
function remove_footer_admin () {
  echo bloginfo('name');
}
add_filter('admin_footer_text', 'remove_footer_admin');

// Remove dashboard meta
function remove_dashboard_meta() {
  remove_meta_box( 'dashboard_incoming_links', 'dashboard', 'normal' );
  remove_meta_box( 'dashboard_plugins', 'dashboard', 'normal' );
  remove_meta_box( 'dashboard_primary', 'dashboard', 'normal' );
  remove_meta_box( 'dashboard_secondary', 'dashboard', 'normal' );
  remove_meta_box( 'dashboard_incoming_links', 'dashboard', 'normal' );
  remove_meta_box( 'dashboard_quick_press', 'dashboard', 'side' );
  remove_meta_box( 'dashboard_recent_drafts', 'dashboard', 'side' );
  remove_meta_box( 'dashboard_recent_comments', 'dashboard', 'normal' );
  remove_meta_box( 'dashboard_right_now', 'dashboard', 'normal' );
}
add_action( 'admin_init', 'remove_dashboard_meta' );

// disable emojis & admin bar
remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
remove_action( 'wp_print_styles', 'print_emoji_styles' );
remove_action( 'admin_print_styles', 'print_emoji_styles' );
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'index_rel_link');
remove_action( 'wp_head', 'admin-bar-css' );
remove_action( 'wp_head', 'boxes-css' );

// disable admin bar
show_admin_bar(false);

// Remove welcome panel
remove_action('welcome_panel', 'wp_welcome_panel');

// Defines
define('DISSALOW_UNFILTERED_HMTL', true );
define('DISSALOW_FILE_EDIT', true);
define ('WP_POST_REVISIONS', 0);
define ('EMPTY_TRASH_DAYS', 7);

// Gallery Metabox
require_once get_template_directory().'/lib/plugins/gallery-metabox/gallery.php';
?>
