<?php
function offer_create_post_type() {
	$labels = array(
		'name' => 'Teklif',
		'singular_name' => 'Teklif',
		'add_new' => 'Teklif Ekle',
		'all_items' => 'Teklif',
		'add_new_item' => 'Teklif Ekle',
		'edit_item' => 'Düzenle',
		'new_item' => 'Yeni Teklif',
		'view_item' => 'Görüntüle',
		'search_items' => 'Ara',
		'not_found' => 'Bölüm bulunamadı',
		'not_found_in_trash' => 'Çöp boş',
		'parent_item_colon' => 'Üst'
	);
	$args = array(
		'labels' => $labels,
		'public' => true,
		'has_archive' => true,
		'publicly_queryable' => true,
		'query_var' => true,
		'rewrite' => true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'supports' => array(
			'title',
      'editor',
      'thumbnail'
		),
		'menu_position' => 4
	);
	register_post_type( 'offer', $args );
}
add_action( 'init', 'offer_create_post_type' );

function view_footer_teklif() {
	$args = array(
		'posts_per_page'  => -1,
		'orderby'         => 'menu_order',
		'order'           => 'DESC',
		'post_type'       => 'offer',
		'post_status'     => 'publish'
	);

	$post = get_posts( $args )[0];

  $images = get_post_meta($post->ID, 'vdw_gallery_id', true);
  $images = unserialize($images);
  if ($images) {
    $html = '';
		$count = 0;
    foreach ($images as $image) {
			if ($count > 7) {
				break;
			}
      $img = wp_get_attachment_image_src($image['id'],'thumbnail');
      $imgf = wp_get_attachment_image_src($image['id'],'large');
      $alt = get_post_meta($image['id'], '_wp_attachment_image_alt', true);
    	$html .= '
      <a class="fancybox-thumb" title="'.$image['head'].'" rel="fancybox-thumb" href="'.$imgf[0].'" style="background-image: url('.$img[0].')"></a>
      ';
			$count++;
    }
  }

	return $html;
}
?>
