<?php
/* Plugin Name: Öznet Seo */

add_action( 'add_meta_boxes', 'oznetseo_add_metabox' );

function oznetseo_add_metabox() {
  add_meta_box( 'oznetseo_metabox', 'SEO Alanları', 'oznetseo_metabox',
  ['page', 'post'],
  'normal' );
}

add_action('admin_init', 'my_general_section');
function my_general_section() {
    add_settings_section(
        'my_settings_section',
        'Anasayfa SEO Bilgileri',
        'my_section_options_callback',
        'general'
    );

    add_settings_field(
        'seo_keywords',
        'SEO Keyword',
        'my_textbox_callback',
        'general',
        'my_settings_section',
        array(
            'seo_keywords'
        )
    );

    add_settings_field( // Option 2
        'seo_description', // Option ID
        'SEO Açıklaması', // Label
        'my_textbox_callback', // !important - This is where the args go!
        'general', // Page it will be displayed
        'my_settings_section', // Name of our section (General Settings)
        array( // The $args
            'seo_description' // Should match Option ID
        )
    );

    register_setting('general','seo_keywords', 'esc_attr');
    register_setting('general','seo_description', 'esc_attr');
}

function my_section_options_callback() { // Section Callback
    echo '<p>Bu alanlar sadece anasayfada gözükecektir</p>';
}

function my_textbox_callback($args) {  // Textbox Callback
    $option = get_option($args[0]);
    echo '<input style="width:300px" type="text" id="'. $args[0] .'" name="'. $args[0] .'" value="' . $option . '" />';
}

// My Shared Callback
function oznetseo_setting_callback($args) {

$options = get_option('ch_essentials_front_page_option');

echo '<input type="text" id="'  . $args[0] . '" name="ch_essentials_front_page_option['  . $args[0] . ']" value="' . $options[''  . $args[0] . ''] . '"></input>';
}

function oznetseo_metabox() {
  global $post;
  // Noncename needed to verify where the data originated
  echo '<input type="hidden" name="oznetseo_post_noncename" value="' . wp_create_nonce( plugin_basename(__FILE__) ) . '" />';

  // Get the data if its already been entered
  $seo_title = get_post_meta($post->ID, 'seo_title', true);
  $seo_desc = get_post_meta($post->ID, 'seo_desc', true);
  $seo_keys = get_post_meta($post->ID, 'seo_keys', true);

  ?>

	<style>
		.seo td, .seo textarea, .seo input {
			width: 80%
		}
	</style>

  <table class="table seo">
		<tr>
      <th>
        <label>Seo Başlık: </label>
      </th>
      <td>
        <input type="text" name="seo_title" value="<?php echo $seo_title; ?>">
      </td>
    </tr>
		<tr>
      <th>
        <label>Seo Açıklama: </label>
      </th>
      <td>
        <textarea rows="5" name="seo_desc"><?php echo $seo_desc; ?></textarea>
      </td>
    </tr>
    <tr>
      <th>
        <label>Seo Keywords: </label>
      </th>
      <td>
        <textarea rows="5" name="seo_keys"><?php echo $seo_keys; ?></textarea>
      </td>
    </tr>
  </table>

<?php
}

function oznetseo_post_save_meta( $post_id, $post ) { // save the data

  if ( ! isset( $_POST['oznetseo_post_noncename'] ) ) { // Check if our nonce is set.
    return;
  }

  // verify this came from the our screen and with proper authorization,
  // because save_post can be triggered at other times
  if( !wp_verify_nonce( $_POST['oznetseo_post_noncename'], plugin_basename(__FILE__) ) ) {
    return $post->ID;
  }

  // is the user allowed to edit the post or page?
  if( ! current_user_can( 'edit_post', $post->ID )){
    return $post->ID;
  }

	$oznetseo_post_meta['seo_title'] = $_POST['seo_title'];
	$oznetseo_post_meta['seo_desc'] = $_POST['seo_desc'];
	$oznetseo_post_meta['seo_keys'] = $_POST['seo_keys'];

  foreach( $oznetseo_post_meta as $key => $value ) {
    $value = implode(',', (array)$value);
    if( get_post_meta( $post->ID, $key, FALSE ) ) {
      update_post_meta($post->ID, $key, $value);
    } else {
      add_post_meta( $post->ID, $key, $value );
    }
    if( !$value ) {
      delete_post_meta( $post->ID, $key );
    }
  }
}
add_action( 'save_post', 'oznetseo_post_save_meta', 1, 2 );

function insertIntoHead() {
  $option_keywords = get_option('seo_keywords');
  $option_desc = get_option('seo_description');
  $home_title = wp_title('|',false,'right').get_bloginfo('name');
  if (is_home()) {
    $title = $home_title;
    $keywords = $option_keywords;
    $description = $option_desc;
  }else {
    $title = get_post_meta(get_the_ID(), 'seo_title', true);
    if ($title == '') {
      $title = $home_title;
    }
    $keywords = get_post_meta(get_the_ID(), 'seo_keys', true);
    if ($keywords == '') {
      $keywords = $option_keywords;
    }
    $description = get_post_meta(get_the_ID(), 'seo_desc', true);
    if ($description == '') {
      $description = $option_desc;
    }
  }

  $export = '
    <title>'.$title.'</title>
    <meta name="description" content="'.$description.'">
    <meta name="keywords" content="'.$keywords.'">
  ';

  echo $export;
}
